/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.utils.Utils;
import java.util.Arrays;
import java.util.List;

public class EntryReference<E extends Entry, C extends Entry> {
    private static final List<String> ConstructorNonNames = Arrays.asList("this", "super", "static");
    public E entry;
    public C context;
    private boolean sourceName;

    public EntryReference(E entry, String sourceName) {
        this(entry, sourceName, null);
    }

    public EntryReference(E entry, String sourceName, C context) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.entry = entry;
        this.context = context;
        boolean bl = this.sourceName = sourceName != null && !sourceName.isEmpty();
        if (entry instanceof ConstructorEntry && ConstructorNonNames.contains(sourceName)) {
            this.sourceName = false;
        }
    }

    public EntryReference(E entry, C context, EntryReference<E, C> other) {
        this.entry = entry;
        this.context = context;
        this.sourceName = other.sourceName;
    }

    public ClassEntry getLocationClassEntry() {
        if (this.context != null) {
            return this.context.getClassEntry();
        }
        return this.entry.getClassEntry();
    }

    public boolean isNamed() {
        return this.sourceName;
    }

    public Entry getNameableEntry() {
        if (this.entry instanceof ConstructorEntry) {
            return this.entry.getClassEntry();
        }
        return this.entry;
    }

    public String getNamableName() {
        ClassEntry classEntry;
        if (this.getNameableEntry() instanceof ClassEntry && (classEntry = (ClassEntry)this.getNameableEntry()).isInnerClass()) {
            return classEntry.getInnermostClassName();
        }
        return this.getNameableEntry().getName();
    }

    public int hashCode() {
        if (this.context != null) {
            return Utils.combineHashesOrdered(this.entry.hashCode(), this.context.hashCode());
        }
        return this.entry.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof EntryReference && this.equals((EntryReference)other);
    }

    public boolean equals(EntryReference<?, ?> other) {
        boolean isEntrySame = this.entry.equals(other.entry);
        if (!isEntrySame) {
            return false;
        }
        if (this.context == null && other.context == null) {
            return true;
        }
        if (this.context != null && other.context != null) {
            return this.context.equals(other.context);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entry);
        if (this.context != null) {
            buf.append(" called from ");
            buf.append(this.context);
        }
        return buf.toString();
    }
}

