/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntryRenamer {
    public static <T> void renameClassesInSet(Map<String, String> renames, Set<T> set) {
        ArrayList entries = Lists.newArrayList();
        for (T val : set) {
            entries.add(EntryRenamer.renameClassesInThing(renames, val));
        }
        set.clear();
        set.addAll(entries);
    }

    public static <Key, Val> void renameClassesInMap(Map<String, String> renames, Map<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry<Key, Val>(EntryRenamer.renameClassesInThing(renames, entry.getKey()), EntryRenamer.renameClassesInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry<Object, Object> entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameClassesInMultimap(Map<String, String> renames, Multimap<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry entry : map.entries()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry(EntryRenamer.renameClassesInThing(renames, entry.getKey()), EntryRenamer.renameClassesInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameMethodsInMultimap(Map<MethodEntry, MethodEntry> renames, Multimap<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry entry : map.entries()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry(EntryRenamer.renameMethodsInThing(renames, entry.getKey()), EntryRenamer.renameMethodsInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameMethodsInMap(Map<MethodEntry, MethodEntry> renames, Map<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry<Key, Val>(EntryRenamer.renameMethodsInThing(renames, entry.getKey()), EntryRenamer.renameMethodsInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry<Object, Object> entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <T> T renameMethodsInThing(Map<MethodEntry, MethodEntry> renames, T thing) {
        if (thing instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)thing;
            MethodEntry newMethodEntry = renames.get(methodEntry);
            if (newMethodEntry != null) {
                return (T)new MethodEntry(methodEntry.getClassEntry(), newMethodEntry.getName(), methodEntry.getSignature());
            }
            return thing;
        }
        if (thing instanceof ArgumentEntry) {
            ArgumentEntry argumentEntry = (ArgumentEntry)thing;
            return (T)new ArgumentEntry(EntryRenamer.renameMethodsInThing(renames, argumentEntry.getBehaviorEntry()), argumentEntry.getIndex(), argumentEntry.getName());
        }
        if (thing instanceof EntryReference) {
            EntryReference reference = (EntryReference)thing;
            reference.entry = (Entry)EntryRenamer.renameMethodsInThing(renames, reference.entry);
            reference.context = (Entry)EntryRenamer.renameMethodsInThing(renames, reference.context);
            return thing;
        }
        return thing;
    }

    public static <T> T renameClassesInThing(Map<String, String> renames, T thing) {
        if (thing instanceof String) {
            String stringEntry = (String)thing;
            if (renames.containsKey(stringEntry)) {
                return (T)renames.get(stringEntry);
            }
        } else {
            if (thing instanceof ClassEntry) {
                ClassEntry classEntry = (ClassEntry)thing;
                return (T)new ClassEntry(EntryRenamer.renameClassesInThing(renames, classEntry.getClassName()));
            }
            if (thing instanceof FieldEntry) {
                FieldEntry fieldEntry = (FieldEntry)thing;
                return (T)new FieldEntry(EntryRenamer.renameClassesInThing(renames, fieldEntry.getClassEntry()), fieldEntry.getName(), EntryRenamer.renameClassesInThing(renames, fieldEntry.getType()));
            }
            if (thing instanceof ConstructorEntry) {
                ConstructorEntry constructorEntry = (ConstructorEntry)thing;
                return (T)new ConstructorEntry(EntryRenamer.renameClassesInThing(renames, constructorEntry.getClassEntry()), EntryRenamer.renameClassesInThing(renames, constructorEntry.getSignature()));
            }
            if (thing instanceof MethodEntry) {
                MethodEntry methodEntry = (MethodEntry)thing;
                return (T)new MethodEntry(EntryRenamer.renameClassesInThing(renames, methodEntry.getClassEntry()), methodEntry.getName(), EntryRenamer.renameClassesInThing(renames, methodEntry.getSignature()));
            }
            if (thing instanceof ArgumentEntry) {
                ArgumentEntry argumentEntry = (ArgumentEntry)thing;
                return (T)new ArgumentEntry(EntryRenamer.renameClassesInThing(renames, argumentEntry.getBehaviorEntry()), argumentEntry.getIndex(), argumentEntry.getName());
            }
            if (thing instanceof EntryReference) {
                EntryReference reference = (EntryReference)thing;
                reference.entry = (Entry)EntryRenamer.renameClassesInThing(renames, reference.entry);
                reference.context = (Entry)EntryRenamer.renameClassesInThing(renames, reference.context);
                return thing;
            }
            if (thing instanceof Signature) {
                return (T)new Signature((Signature)thing, className -> EntryRenamer.renameClassesInThing(renames, className));
            }
            if (thing instanceof Type) {
                return (T)new Type((Type)thing, className -> EntryRenamer.renameClassesInThing(renames, className));
            }
        }
        return thing;
    }
}

