/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Translator;
import javax.swing.tree.DefaultMutableTreeNode;

public class FieldReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<FieldEntry, BehaviorEntry> {
    private Translator deobfuscatingTranslator;
    private FieldEntry entry;
    private EntryReference<FieldEntry, BehaviorEntry> reference;
    private Access access;

    public FieldReferenceTreeNode(Translator deobfuscatingTranslator, FieldEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    private FieldReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<FieldEntry, BehaviorEntry> reference, Access access) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (FieldEntry)reference.entry;
        this.reference = reference;
        this.access = access;
    }

    @Override
    public FieldEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<FieldEntry, BehaviorEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s (%s)", new Object[]{this.deobfuscatingTranslator.translateEntry((BehaviorEntry)this.reference.context), this.access});
        }
        return this.deobfuscatingTranslator.translateEntry(this.entry).toString();
    }

    public void load(JarIndex index, boolean recurse) {
        if (this.reference == null) {
            for (EntryReference<Entry, BehaviorEntry> entryReference : index.getFieldReferences(this.entry)) {
                this.add(new FieldReferenceTreeNode(this.deobfuscatingTranslator, entryReference, index.getAccess(this.entry)));
            }
        } else {
            for (EntryReference<Entry, BehaviorEntry> entryReference : index.getBehaviorReferences((BehaviorEntry)this.reference.context)) {
                this.add(new BehaviorReferenceTreeNode(this.deobfuscatingTranslator, entryReference, index.getAccess((Entry)this.reference.context)));
            }
        }
        if (recurse && this.children != null) {
            for (EntryReference<Entry, BehaviorEntry> entryReference : this.children) {
                if (entryReference instanceof BehaviorReferenceTreeNode) {
                    ((BehaviorReferenceTreeNode)((Object)entryReference)).load(index, true);
                    continue;
                }
                if (!(entryReference instanceof FieldReferenceTreeNode)) continue;
                ((FieldReferenceTreeNode)((Object)entryReference)).load(index, true);
            }
        }
    }
}

