/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.ProcyonEntryFactory;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.Descriptor;

public class SourceIndexBehaviorVisitor
extends SourceIndexVisitor {
    private BehaviorEntry behaviorEntry;
    private int argumentPosition;
    private int localsPosition;
    private Multimap<String, Identifier> unmatchedIdentifier = HashMultimap.create();
    private Map<String, Entry> identifierEntryCache = new HashMap<String, Entry>();

    public SourceIndexBehaviorVisitor(BehaviorEntry behaviorEntry, boolean isEnum) {
        this.behaviorEntry = behaviorEntry;
        this.argumentPosition = isEnum ? 2 : 0;
        this.localsPosition = 0;
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
        BehaviorEntry behaviorEntry = null;
        if (ref instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)ref;
            behaviorEntry = methodRef.isConstructor() ? new ConstructorEntry(classEntry, new Signature(ref.getErasedSignature())) : (methodRef.isTypeInitializer() ? new ConstructorEntry(classEntry) : new MethodEntry(classEntry, ref.getName(), new Signature(ref.getErasedSignature())));
        }
        if (behaviorEntry != null) {
            Identifier tokenNode = null;
            if (node.getTarget() instanceof MemberReferenceExpression) {
                tokenNode = ((MemberReferenceExpression)node.getTarget()).getMemberNameToken();
            } else if (node.getTarget() instanceof SuperReferenceExpression) {
                tokenNode = node.getTarget();
            } else if (node.getTarget() instanceof ThisReferenceExpression) {
                tokenNode = node.getTarget();
            }
            if (tokenNode != null) {
                index.addReference((AstNode)tokenNode, behaviorEntry, this.behaviorEntry);
            }
        }
        node.getArguments().stream().filter(expression -> expression instanceof IdentifierExpression).forEach(expression -> this.checkIdentifier((IdentifierExpression)expression, index));
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            if (ref.getErasedSignature().indexOf(40) >= 0) {
                throw new Error("Expected a field here! got " + ref);
            }
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new Type(ref.getErasedSignature()));
            index.addReference((AstNode)node.getMemberNameToken(), fieldEntry, this.behaviorEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = (TypeReference)node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference((AstNode)node.getIdentifierToken(), classEntry, this.behaviorEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitParameterDeclaration(ParameterDeclaration node, SourceIndex index) {
        ParameterDefinition def = (ParameterDefinition)node.getUserData(Keys.PARAMETER_DEFINITION);
        if (def.getMethod() instanceof MemberReference && def.getMethod() instanceof MethodReference) {
            ArgumentEntry argumentEntry = new ArgumentEntry(ProcyonEntryFactory.getBehaviorEntry((MethodReference)def.getMethod()), this.argumentPosition++, node.getName());
            Identifier identifier = node.getNameToken();
            this.identifierEntryCache.put(identifier.getName(), argumentEntry);
            index.addDeclaration((AstNode)identifier, argumentEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitIdentifierExpression(IdentifierExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new Type(ref.getErasedSignature()));
            index.addReference((AstNode)node.getIdentifierToken(), fieldEntry, this.behaviorEntry);
        } else {
            this.checkIdentifier(node, index);
        }
        return this.recurse((AstNode)node, index);
    }

    private void checkIdentifier(IdentifierExpression node, SourceIndex index) {
        if (this.identifierEntryCache.containsKey(node.getIdentifier())) {
            index.addDeclaration((AstNode)node.getIdentifierToken(), this.identifierEntryCache.get(node.getIdentifier()));
        } else {
            this.unmatchedIdentifier.put((Object)node.getIdentifier(), (Object)node.getIdentifierToken());
        }
    }

    private void addDeclarationToUnmatched(String key, SourceIndex index) {
        Entry entry = this.identifierEntryCache.get(key);
        if (entry == null) {
            return;
        }
        for (Identifier identifier : this.unmatchedIdentifier.get((Object)key)) {
            index.addDeclaration((AstNode)identifier, entry);
        }
        this.unmatchedIdentifier.removeAll((Object)key);
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            ConstructorEntry constructorEntry = new ConstructorEntry(classEntry, new Signature(ref.getErasedSignature()));
            if (node.getType() instanceof SimpleType) {
                SimpleType simpleTypeNode = (SimpleType)node.getType();
                index.addReference((AstNode)simpleTypeNode.getIdentifierToken(), constructorEntry, this.behaviorEntry);
            }
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitForEachStatement(ForEachStatement node, SourceIndex index) {
        if (node.getVariableType() instanceof SimpleType) {
            SimpleType type = (SimpleType)node.getVariableType();
            TypeReference typeReference = (TypeReference)type.getUserData(Keys.TYPE_REFERENCE);
            Identifier identifier = node.getVariableNameToken();
            String signature = Descriptor.of((String)typeReference.getErasedDescription());
            LocalVariableEntry localVariableEntry = new LocalVariableEntry(this.behaviorEntry, this.argumentPosition + this.localsPosition++, identifier.getName(), new Type(signature));
            this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
            this.addDeclarationToUnmatched(identifier.getName(), index);
            index.addDeclaration((AstNode)identifier, localVariableEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclarationStatement node, SourceIndex index) {
        VariableInitializer initializer;
        AstNodeCollection variables = node.getVariables();
        if (variables.size() == 1 && (initializer = (VariableInitializer)variables.firstOrNullObject()) != null && node.getType() instanceof SimpleType) {
            SimpleType type = (SimpleType)node.getType();
            TypeReference typeReference = (TypeReference)type.getUserData(Keys.TYPE_REFERENCE);
            String signature = Descriptor.of((String)typeReference.getErasedDescription());
            Identifier identifier = initializer.getNameToken();
            LocalVariableEntry localVariableEntry = new LocalVariableEntry(this.behaviorEntry, this.argumentPosition + this.localsPosition++, initializer.getName(), new Type(signature));
            this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
            this.addDeclarationToUnmatched(identifier.getName(), index);
            index.addDeclaration((AstNode)identifier, localVariableEntry);
        }
        return this.recurse((AstNode)node, index);
    }
}

