/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.Descriptor;

public class TranslationIndex {
    private Map<ClassEntry, ClassEntry> superclasses = Maps.newHashMap();
    private Multimap<ClassEntry, FieldEntry> fieldEntries;
    private Multimap<ClassEntry, BehaviorEntry> behaviorEntries;
    private Multimap<ClassEntry, ClassEntry> interfaces;

    public TranslationIndex() {
        this.fieldEntries = HashMultimap.create();
        this.behaviorEntries = HashMultimap.create();
        this.interfaces = HashMultimap.create();
    }

    public TranslationIndex(TranslationIndex other, Translator translator) {
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.superclasses.entrySet()) {
            this.superclasses.put(translator.translateEntry(mapEntry.getKey()), translator.translateEntry(mapEntry.getValue()));
        }
        this.interfaces = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.interfaces.entries()) {
            this.interfaces.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry(mapEntry.getValue()));
        }
        this.fieldEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.fieldEntries.entries()) {
            this.fieldEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((FieldEntry)((Object)mapEntry.getValue())));
        }
        this.behaviorEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.behaviorEntries.entries()) {
            this.behaviorEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((BehaviorEntry)((Object)mapEntry.getValue())));
        }
    }

    public void indexClass(CtClass c) {
        this.indexClass(c, true);
    }

    public void indexClass(CtClass c, boolean indexMembers) {
        ClassEntry classEntry = EntryFactory.getClassEntry(c);
        if (this.isJre(classEntry)) {
            return;
        }
        ClassEntry superclassEntry = EntryFactory.getSuperclassEntry(c);
        if (superclassEntry != null) {
            this.superclasses.put(classEntry, superclassEntry);
        }
        for (String string : c.getClassFile().getInterfaces()) {
            ClassEntry interfaceClassEntry = new ClassEntry(Descriptor.toJvmName((String)string));
            if (this.isJre(interfaceClassEntry)) continue;
            this.interfaces.put((Object)classEntry, (Object)interfaceClassEntry);
        }
        if (indexMembers) {
            for (String string : c.getDeclaredFields()) {
                FieldEntry fieldEntry = EntryFactory.getFieldEntry((CtField)string);
                this.fieldEntries.put((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
            }
            for (String string : c.getDeclaredBehaviors()) {
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)string);
                this.behaviorEntries.put((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
            }
        }
    }

    public void renameClasses(Map<String, String> renames) {
        EntryRenamer.renameClassesInMap(renames, this.superclasses);
        EntryRenamer.renameClassesInMultimap(renames, this.fieldEntries);
        EntryRenamer.renameClassesInMultimap(renames, this.behaviorEntries);
    }

    public ClassEntry getSuperclass(ClassEntry classEntry) {
        return this.superclasses.get(classEntry);
    }

    public List<ClassEntry> getAncestry(ClassEntry classEntry) {
        ArrayList ancestors = Lists.newArrayList();
        while (classEntry != null) {
            if ((classEntry = this.getSuperclass(classEntry)) == null) continue;
            ancestors.add(classEntry);
        }
        return ancestors;
    }

    public List<ClassEntry> getSubclass(ClassEntry classEntry) {
        ArrayList subclasses = Lists.newArrayList();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.superclasses.entrySet()) {
            ClassEntry subclass = entry.getKey();
            ClassEntry superclass = entry.getValue();
            if (!classEntry.equals(superclass)) continue;
            subclasses.add(subclass);
        }
        return subclasses;
    }

    public void getSubclassesRecursively(Set<ClassEntry> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry);
            this.getSubclassesRecursively(out, subclassEntry);
        }
    }

    public void getSubclassNamesRecursively(Set<String> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry.getName());
            this.getSubclassNamesRecursively(out, subclassEntry);
        }
    }

    public Collection<Map.Entry<ClassEntry, ClassEntry>> getClassInterfaces() {
        return this.interfaces.entries();
    }

    public Collection<ClassEntry> getInterfaces(ClassEntry classEntry) {
        return this.interfaces.get((Object)classEntry);
    }

    public boolean isInterface(ClassEntry classEntry) {
        return this.interfaces.containsValue((Object)classEntry);
    }

    public boolean entryExists(Entry entry) {
        if (entry instanceof FieldEntry) {
            return this.fieldExists((FieldEntry)entry);
        }
        if (entry instanceof BehaviorEntry) {
            return this.behaviorExists((BehaviorEntry)entry);
        }
        if (entry instanceof ArgumentEntry) {
            return this.behaviorExists(((ArgumentEntry)entry).getBehaviorEntry());
        }
        if (entry instanceof LocalVariableEntry) {
            return this.behaviorExists(((LocalVariableEntry)entry).getBehaviorEntry());
        }
        throw new IllegalArgumentException("Cannot check existence for " + entry.getClass());
    }

    public boolean fieldExists(FieldEntry fieldEntry) {
        return this.fieldEntries.containsEntry((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
    }

    public boolean behaviorExists(BehaviorEntry behaviorEntry) {
        return this.behaviorEntries.containsEntry((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
    }

    public ClassEntry resolveEntryClass(Entry entry) {
        return this.resolveEntryClass(entry, false);
    }

    public ClassEntry resolveEntryClass(Entry entry, boolean checkSuperclassBeforeChild) {
        if (entry instanceof ClassEntry) {
            return (ClassEntry)entry;
        }
        ClassEntry superclassEntry = this.resolveSuperclass(entry, checkSuperclassBeforeChild);
        if (superclassEntry != null) {
            return superclassEntry;
        }
        ClassEntry interfaceEntry = this.resolveInterface(entry);
        if (interfaceEntry != null) {
            return interfaceEntry;
        }
        return null;
    }

    public ClassEntry resolveSuperclass(Entry entry, boolean checkSuperclassBeforeChild) {
        if (!checkSuperclassBeforeChild) {
            return this.resolveSuperclass(entry);
        }
        Entry originalEntry = entry;
        List superclasses = Lists.reverse(this.getAncestry(originalEntry.getClassEntry()));
        boolean existInEntry = false;
        for (ClassEntry classEntry : superclasses) {
            entry = entry.cloneToNewClass(classEntry);
            existInEntry = this.entryExists(entry);
            ClassEntry interfaceEntry = this.resolveInterface(entry);
            if (interfaceEntry != null) {
                return interfaceEntry;
            }
            if (!existInEntry) continue;
            break;
        }
        if (!existInEntry) {
            return !this.entryExists(originalEntry) ? null : originalEntry.getClassEntry();
        }
        return entry.getClassEntry();
    }

    public ClassEntry resolveSuperclass(Entry entry) {
        while (!this.entryExists(entry)) {
            ClassEntry superclassEntry = this.getSuperclass(entry.getClassEntry());
            if (superclassEntry == null) {
                return null;
            }
            entry = entry.cloneToNewClass(superclassEntry);
        }
        return entry.getClassEntry();
    }

    public ClassEntry resolveInterface(Entry entry) {
        for (ClassEntry interfaceEntry : this.interfaces.get((Object)entry.getClassEntry())) {
            ClassEntry result;
            Collection subInterface = this.interfaces.get((Object)interfaceEntry);
            if (subInterface != null && !subInterface.isEmpty() && (result = this.resolveInterface(entry.cloneToNewClass(interfaceEntry))) != null) {
                return result;
            }
            ClassEntry resolvedClassEntry = this.resolveSuperclass(entry.cloneToNewClass(interfaceEntry));
            if (resolvedClassEntry == null) continue;
            return resolvedClassEntry;
        }
        return null;
    }

    private boolean isJre(ClassEntry classEntry) {
        String packageName = classEntry.getPackageName();
        return packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax"));
    }
}

