/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.translators.InnerClassWriter;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.SourceFileAttribute;

public class ClassTranslator {
    public static void translate(Translator translator, CtClass c) {
        InnerClassesAttribute attr;
        Entry entry;
        ConstPool constants = c.getClassFile().getConstPool();
        ConstPoolEditor editor = new ConstPoolEditor(constants);
        block4: for (int i = 1; i < constants.getSize(); ++i) {
            switch (constants.getTag(i)) {
                case 9: {
                    Entry entry2 = EntryFactory.getFieldEntry(Descriptor.toJvmName((String)constants.getFieldrefClassName(i)), constants.getFieldrefName(i), constants.getFieldrefType(i));
                    Object translatedEntry = translator.translateEntry((FieldEntry)entry2);
                    if (((FieldEntry)entry2).equals((FieldEntry)translatedEntry)) continue block4;
                    editor.changeMemberrefNameAndType(i, ((FieldEntry)translatedEntry).getName(), ((FieldEntry)translatedEntry).getType().toString());
                    continue block4;
                }
                case 10: 
                case 11: {
                    Entry entry2 = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)editor.getMemberrefClassname(i)), editor.getMemberrefName(i), editor.getMemberrefType(i));
                    Object translatedEntry = translator.translateEntry((BehaviorEntry)entry2);
                    if (entry2.equals(translatedEntry)) continue block4;
                    editor.changeMemberrefNameAndType(i, translatedEntry.getName(), translatedEntry.getSignature().toString());
                    continue block4;
                }
            }
        }
        ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        Mappings.EntryModifier modifier = translator.getModifier(classEntry);
        if (modifier != null && modifier != Mappings.EntryModifier.UNCHANGED) {
            ClassRenamer.applyModifier(c, modifier);
        }
        for (CtField field : c.getDeclaredFields()) {
            entry = EntryFactory.getFieldEntry(field);
            String translatedName = translator.translate((FieldEntry)entry);
            modifier = translator.getModifier(entry);
            if (modifier != null && modifier != Mappings.EntryModifier.UNCHANGED) {
                ClassRenamer.applyModifier(field, modifier);
            }
            if (translatedName != null) {
                field.setName(translatedName);
            }
            Type translatedType = translator.translateType(((FieldEntry)entry).getType());
            field.getFieldInfo().setDescriptor(translatedType.toString());
        }
        for (CtBehavior behavior : c.getDeclaredBehaviors()) {
            entry = EntryFactory.getBehaviorEntry(behavior);
            modifier = translator.getModifier(entry);
            if (modifier != null && modifier != Mappings.EntryModifier.UNCHANGED) {
                ClassRenamer.applyModifier(behavior, modifier);
            }
            if (behavior instanceof CtMethod) {
                CtMethod method = (CtMethod)behavior;
                String translatedName = translator.translate(entry);
                if (translatedName != null) {
                    method.setName(translatedName);
                }
            }
            if (entry.getSignature() == null) continue;
            Signature translatedSignature = translator.translateSignature(entry.getSignature());
            behavior.getMethodInfo().setDescriptor(translatedSignature.toString());
        }
        EnclosingMethodAttribute enclosingMethodAttr = (EnclosingMethodAttribute)c.getClassFile().getAttribute("EnclosingMethod");
        if (enclosingMethodAttr != null) {
            if (enclosingMethodAttr.methodIndex() == 0) {
                BehaviorEntry obfBehaviorEntry = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)enclosingMethodAttr.className()));
                BehaviorEntry deobfBehaviorEntry = translator.translateEntry(obfBehaviorEntry);
                c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(constants, deobfBehaviorEntry.getClassName()));
            } else {
                BehaviorEntry obfBehaviorEntry = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)enclosingMethodAttr.className()), enclosingMethodAttr.methodName(), enclosingMethodAttr.methodDescriptor());
                BehaviorEntry deobfBehaviorEntry = translator.translateEntry(obfBehaviorEntry);
                c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(constants, deobfBehaviorEntry.getClassName(), deobfBehaviorEntry.getName(), deobfBehaviorEntry.getSignature().toString()));
            }
        }
        ClassRenamer.renameClasses(c, translator);
        ClassEntry deobfClassEntry = translator.translateEntry(classEntry);
        if (deobfClassEntry != null) {
            String sourceFile = Descriptor.toJvmName((String)deobfClassEntry.getOutermostClassEntry().getSimpleName()) + ".java";
            c.getClassFile().addAttribute((AttributeInfo)new SourceFileAttribute(constants, sourceFile));
        }
        if ((attr = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses")) != null) {
            InnerClassWriter.changeModifier(c, attr, translator);
        }
    }
}

