/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;

public class LocalVariableTranslator {
    public static void translate(Translator translator, CtClass c) {
        for (CtBehavior behavior : c.getDeclaredBehaviors()) {
            LocalVariableTypeAttribute typeTable;
            CodeAttribute codeAttribute = behavior.getMethodInfo().getCodeAttribute();
            if (codeAttribute == null) continue;
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
            ConstPool constants = c.getClassFile().getConstPool();
            LocalVariableAttribute table = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            if (table != null) {
                LocalVariableTranslator.renameLVT(translator, behaviorEntry, constants, table, c);
            }
            if ((typeTable = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) == null) continue;
            LocalVariableTranslator.renameLVTT(typeTable, table);
        }
    }

    private static void dumpTable(LocalVariableAttribute table) {
        for (int i = 0; i < table.tableLength(); ++i) {
            System.out.println(String.format("\t%d (%d): %s %s", i, table.index(i), table.variableName(i), table.descriptor(i)));
        }
    }

    private static void renameLVT(Translator translator, BehaviorEntry behaviorEntry, ConstPool constants, LocalVariableAttribute table, CtClass ctClass) {
        if (table.tableLength() <= 0) {
            return;
        }
        int starti = 0;
        if (table.variableName(0).equals("this")) {
            ++starti;
        }
        int numArgs = 0;
        if (behaviorEntry.getSignature() != null) {
            Type firstArg;
            numArgs = behaviorEntry.getSignature().getArgumentTypes().size();
            boolean isNestedClassConstructor = false;
            if (behaviorEntry instanceof ConstructorEntry && behaviorEntry.getClassEntry() != null && behaviorEntry.getClassEntry().isInnerClass() && numArgs >= 1 && (firstArg = behaviorEntry.getSignature().getArgumentTypes().get(0)).isClass() && firstArg.getClassEntry().equals(behaviorEntry.getClassEntry().getOuterClassEntry())) {
                isNestedClassConstructor = true;
                --numArgs;
            }
            for (int i = starti; i < starti + numArgs && i < table.tableLength(); ++i) {
                String argName;
                int argi = i - starti;
                if (ctClass.isEnum()) {
                    argi += 2;
                }
                if ((argName = translator.translate(new ArgumentEntry(behaviorEntry, argi, ""))) == null) {
                    Type argType;
                    int argIndex;
                    int n = argIndex = isNestedClassConstructor ? argi + 1 : argi;
                    if (ctClass.isEnum()) {
                        argIndex -= 2;
                    }
                    if ((argType = behaviorEntry.getSignature().getArgumentTypes().get(argIndex)).isPrimitive()) {
                        Type.Primitive argCls = argType.getPrimitive();
                        argName = "a" + argCls.name() + (argIndex + 1);
                    } else if (argType.isArray()) {
                        argName = "aList" + (argIndex + 1);
                    } else if (argType.isClass()) {
                        ClassEntry argClsTrans = translator.translateEntry(argType.getClassEntry());
                        argName = "a" + argClsTrans.getSimpleName().replace("$", "") + (argIndex + 1);
                    } else {
                        argName = "a" + (argIndex + 1);
                    }
                }
                LocalVariableTranslator.renameVariable(table, i, constants.addUtf8Info(argName));
            }
        }
        for (int i = starti + numArgs; i < table.tableLength(); ++i) {
            int firstIndex = Math.min(table.index(starti + numArgs), table.index(i));
            LocalVariableTranslator.renameVariable(table, i, constants.addUtf8Info("v" + (table.index(i) - firstIndex + 1)));
        }
    }

    private static void renameLVTT(LocalVariableTypeAttribute typeTable, LocalVariableAttribute table) {
        for (int i = 0; i < typeTable.tableLength(); ++i) {
            LocalVariableTranslator.renameVariable((LocalVariableAttribute)typeTable, i, LocalVariableTranslator.getNameIndex(table, typeTable.index(i)));
        }
    }

    private static void renameVariable(LocalVariableAttribute table, int i, int stringId) {
        ByteArray.write16bit((int)stringId, (byte[])table.get(), (int)(i * 10 + 6));
    }

    private static int getNameIndex(LocalVariableAttribute table, int index) {
        for (int i = 0; i < table.tableLength(); ++i) {
            if (table.index(i) != index) continue;
            return table.nameIndex(i);
        }
        return 0;
    }
}

