/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.utils.Utils;

public class ConstructorEntry
implements BehaviorEntry {
    private ClassEntry classEntry;
    private Signature signature;

    public ConstructorEntry(ClassEntry classEntry) {
        this(classEntry, null);
    }

    public ConstructorEntry(ClassEntry classEntry, Signature signature) {
        if (classEntry == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        this.classEntry = classEntry;
        this.signature = signature;
    }

    public ConstructorEntry(ConstructorEntry other, String newClassName) {
        this.classEntry = new ClassEntry(newClassName);
        this.signature = other.signature;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    @Override
    public String getName() {
        if (this.isStatic()) {
            return "<clinit>";
        }
        return "<init>";
    }

    public boolean isStatic() {
        return this.signature == null;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public String getClassName() {
        return this.classEntry.getName();
    }

    @Override
    public ConstructorEntry cloneToNewClass(ClassEntry classEntry) {
        return new ConstructorEntry(this, classEntry.getName());
    }

    public int hashCode() {
        if (this.isStatic()) {
            return Utils.combineHashesOrdered(this.classEntry);
        }
        return Utils.combineHashesOrdered(this.classEntry, this.signature);
    }

    public boolean equals(Object other) {
        return other instanceof ConstructorEntry && this.equals((ConstructorEntry)other);
    }

    public boolean equals(ConstructorEntry other) {
        if (this.isStatic() != other.isStatic()) {
            return false;
        }
        if (this.isStatic()) {
            return this.classEntry.equals(other.classEntry);
        }
        return this.classEntry.equals(other.classEntry) && this.signature.equals(other.signature);
    }

    public String toString() {
        if (this.isStatic()) {
            return this.classEntry.getName() + "." + this.getName();
        }
        return this.classEntry.getName() + "." + this.getName() + this.signature;
    }
}

