/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.throwables.MappingConflict;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class MappingsRenamer {
    private JarIndex index;
    private Mappings mappings;

    public MappingsRenamer(JarIndex index, Mappings mappings) {
        this.index = index;
        this.mappings = mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setClassName(ClassEntry obf, String deobfName) {
        deobfName = NameValidator.validateClassName(deobfName, !obf.isInnerClass());
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            if (deobfName != null && (this.mappings.containsDeobfClass(deobfName) || this.index.containsObfClass(new ClassEntry(deobfName)))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            ClassMapping classMapping = mappingChain.get(0);
            this.mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            if (deobfName != null && (outerClassMapping.hasInnerClassByDeobf(deobfName) || outerClassMapping.hasInnerClassByObfSimple(deobfName))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void removeClassMapping(ClassEntry obf) {
        this.setClassName(obf, null);
    }

    public void markClassAsDeobfuscated(ClassEntry obf) {
        String deobfName = obf.isInnerClass() ? obf.getInnermostClassName() : obf.getName();
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            ClassMapping classMapping = mappingChain.get(0);
            this.mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void setFieldName(FieldEntry obf, String deobfName) {
        deobfName = NameValidator.validateFieldName(deobfName);
        FieldEntry targetEntry = new FieldEntry(obf.getClassEntry(), deobfName, obf.getType());
        ClassEntry definedClass = null;
        if (this.mappings.containsDeobfField(obf.getClassEntry(), deobfName) || this.index.containsEntryWithSameName(targetEntry)) {
            definedClass = obf.getClassEntry();
        } else {
            for (ClassEntry ancestorEntry : this.index.getTranslationIndex().getAncestry(obf.getClassEntry())) {
                if (!this.mappings.containsDeobfField(ancestorEntry, deobfName) && !this.index.containsEntryWithSameName(targetEntry.cloneToNewClass(ancestorEntry))) continue;
                definedClass = ancestorEntry;
                break;
            }
        }
        if (definedClass != null) {
            String className = this.mappings.getTranslator(TranslationDirection.Deobfuscating, this.index.getTranslationIndex()).translateClass(definedClass.getClassName());
            if (className == null) {
                className = definedClass.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a field with that name in " + className);
        }
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getType(), deobfName);
    }

    public void removeFieldMapping(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.removeFieldMapping(classMapping.getFieldByObf(obf.getName(), obf.getType()));
    }

    public void markFieldAsDeobfuscated(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getType(), obf.getName());
    }

    private void validateMethodTreeName(MethodEntry entry, String deobfName) {
        MethodEntry targetEntry = new MethodEntry(entry.getClassEntry(), deobfName, entry.getSignature());
        ClassMapping classMapping = this.mappings.getClassByObf(entry.getClassEntry());
        if (classMapping != null && classMapping.containsDeobfMethod(deobfName, entry.getSignature()) && classMapping.getMethodByObf(entry.getName(), entry.getSignature()) != classMapping.getMethodByDeobf(deobfName, entry.getSignature()) || this.index.containsObfBehavior(targetEntry)) {
            String deobfClassName = this.mappings.getTranslator(TranslationDirection.Deobfuscating, this.index.getTranslationIndex()).translateClass(entry.getClassName());
            if (deobfClassName == null) {
                deobfClassName = entry.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        for (ClassEntry child : this.index.getTranslationIndex().getSubclass(entry.getClassEntry())) {
            this.validateMethodTreeName(entry.cloneToNewClass(child), deobfName);
        }
    }

    public void setMethodTreeName(MethodEntry obf, String deobfName) {
        Set<MethodEntry> implementations = this.index.getRelatedMethodImplementations(obf);
        deobfName = NameValidator.validateMethodName(deobfName);
        for (MethodEntry entry : implementations) {
            this.validateMethodTreeName(entry, deobfName);
        }
        for (MethodEntry entry : implementations) {
            this.setMethodName(entry, deobfName);
        }
    }

    public void setMethodName(MethodEntry obf, String deobfName) {
        deobfName = NameValidator.validateMethodName(deobfName);
        MethodEntry targetEntry = new MethodEntry(obf.getClassEntry(), deobfName, obf.getSignature());
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        if (this.mappings.containsDeobfMethod(obf.getClassEntry(), deobfName, obf.getSignature()) && classMapping.getMethodByObf(obf.getName(), obf.getSignature()) != classMapping.getMethodByDeobf(deobfName, obf.getSignature()) || this.index.containsObfBehavior(targetEntry)) {
            String deobfClassName = this.mappings.getTranslator(TranslationDirection.Deobfuscating, this.index.getTranslationIndex()).translateClass(obf.getClassName());
            if (deobfClassName == null) {
                deobfClassName = obf.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        classMapping.setMethodName(obf.getName(), obf.getSignature(), deobfName);
    }

    public void removeMethodTreeMapping(MethodEntry obf) {
        this.index.getRelatedMethodImplementations(obf).forEach(this::removeMethodMapping);
    }

    public void removeMethodMapping(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getSignature(), null);
    }

    public void markMethodTreeAsDeobfuscated(MethodEntry obf) {
        this.index.getRelatedMethodImplementations(obf).forEach(this::markMethodAsDeobfuscated);
    }

    public void markMethodAsDeobfuscated(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getSignature(), obf.getName());
    }

    public void setArgumentTreeName(ArgumentEntry obf, String deobfName) {
        if (!(obf.getBehaviorEntry() instanceof MethodEntry)) {
            this.setArgumentName(obf, deobfName);
            return;
        }
        MethodEntry obfMethod = (MethodEntry)obf.getBehaviorEntry();
        Set<MethodEntry> implementations = this.index.getRelatedMethodImplementations(obfMethod);
        for (MethodEntry entry : implementations) {
            MethodMapping mapping;
            ClassMapping classMapping = this.mappings.getClassByObf(entry.getClassEntry());
            if (classMapping == null || (mapping = classMapping.getMethodByObf(entry.getName(), entry.getSignature())) == null) continue;
            for (ArgumentMapping argumentMapping : Lists.newArrayList(mapping.arguments())) {
                if (argumentMapping.getIndex() == obf.getIndex() || !mapping.getDeobfArgumentName(argumentMapping.getIndex()).equals(deobfName) && !argumentMapping.getName().equals(deobfName)) continue;
                throw new IllegalNameException(deobfName, "There is already an argument with that name");
            }
        }
        for (MethodEntry entry : implementations) {
            this.setArgumentName(new ArgumentEntry(obf, entry), deobfName);
        }
    }

    public void setArgumentName(ArgumentEntry obf, String deobfName) {
        deobfName = NameValidator.validateArgumentName(deobfName);
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        MethodMapping mapping = classMapping.getMethodByObf(obf.getMethodName(), obf.getMethodSignature());
        if (mapping != null) {
            for (ArgumentMapping argumentMapping : Lists.newArrayList(mapping.arguments())) {
                if (argumentMapping.getIndex() == obf.getIndex() || !mapping.getDeobfArgumentName(argumentMapping.getIndex()).equals(deobfName) && !argumentMapping.getName().equals(deobfName)) continue;
                throw new IllegalNameException(deobfName, "There is already an argument with that name");
            }
        }
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex(), deobfName);
    }

    public void removeArgumentMapping(ArgumentEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.removeArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex());
    }

    public void markArgumentAsDeobfuscated(ArgumentEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex(), obf.getName());
    }

    public boolean moveFieldToObfClass(ClassMapping classMapping, FieldMapping fieldMapping, ClassEntry obfClass) {
        classMapping.removeFieldMapping(fieldMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfField(fieldMapping.getObfName(), fieldMapping.getObfType())) {
            if (!targetClassMapping.containsDeobfField(fieldMapping.getDeobfName(), fieldMapping.getObfType())) {
                targetClassMapping.addFieldMapping(fieldMapping);
                return true;
            }
            System.err.println("WARNING: deobf field was already there: " + obfClass + "." + fieldMapping.getDeobfName());
        }
        return false;
    }

    public boolean moveMethodToObfClass(ClassMapping classMapping, MethodMapping methodMapping, ClassEntry obfClass) {
        classMapping.removeMethodMapping(methodMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfMethod(methodMapping.getObfName(), methodMapping.getObfSignature())) {
            if (!targetClassMapping.containsDeobfMethod(methodMapping.getDeobfName(), methodMapping.getObfSignature())) {
                targetClassMapping.addMethodMapping(methodMapping);
                return true;
            }
            System.err.println("WARNING: deobf method was already there: " + obfClass + "." + methodMapping.getDeobfName() + methodMapping.getObfSignature());
        }
        return false;
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this);
        gzipout.finish();
    }

    private ClassMapping getOrCreateClassMapping(ClassEntry obfClassEntry) {
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obfClassEntry);
        return mappingChain.get(mappingChain.size() - 1);
    }

    private List<ClassMapping> getOrCreateClassMappingChain(ClassEntry obfClassEntry) {
        List<ClassEntry> classChain = obfClassEntry.getClassChain();
        List<ClassMapping> mappingChain = this.mappings.getClassMappingChain(obfClassEntry);
        for (int i = 0; i < classChain.size(); ++i) {
            ClassEntry classEntry = classChain.get(i);
            ClassMapping classMapping = mappingChain.get(i);
            if (classMapping != null) continue;
            classMapping = new ClassMapping(classEntry.getName());
            mappingChain.set(i, classMapping);
            try {
                if (i == 0) {
                    this.mappings.addClassMapping(classMapping);
                    continue;
                }
                mappingChain.get(i - 1).addInnerClassMapping(classMapping);
                continue;
            }
            catch (MappingConflict mappingConflict) {
                mappingConflict.printStackTrace();
            }
        }
        return mappingChain;
    }

    public void setClassModifier(ClassEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry);
        classMapping.setModifier(modifier);
    }

    public void setFieldModifier(FieldEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry.getClassEntry());
        classMapping.setFieldModifier(obEntry.getName(), obEntry.getType(), modifier);
    }

    public void setMethodModifier(BehaviorEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry.getClassEntry());
        classMapping.setMethodModifier(obEntry.getName(), obEntry.getSignature(), modifier);
    }
}

