/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.MappingConflict;
import cuchaz.enigma.throwables.MappingParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MappingsTinyReader {
    public ClassMapping readClass(String[] parts) {
        String deobName = parts[2].contains("$") ? parts[2].substring(parts[2].lastIndexOf(36) + 1) : parts[2];
        return new ClassMapping(parts[1], deobName).setDeobInner(parts[2]);
    }

    public FieldMapping readField(String[] parts) {
        return new FieldMapping(parts[3], new Type(parts[2]), parts[4], Mappings.EntryModifier.UNCHANGED);
    }

    public MethodMapping readMethod(String[] parts) {
        return new MethodMapping(parts[3], new Signature(parts[2]), parts[4]);
    }

    public Mappings read(File file) throws IOException, MappingParseException {
        Mappings mappings = new Mappings(Mappings.FormatType.TINY_FILE);
        List<String> lines = Files.readAllLines(file.toPath(), Charsets.UTF_8);
        HashMap classMappingMap = Maps.newHashMap();
        lines.remove(0);
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            String[] parts = line.split("\t");
            try {
                String token;
                switch (token = parts[0]) {
                    case "CLASS": {
                        ClassMapping classMapping;
                        if (classMappingMap.containsKey(parts[1])) {
                            classMapping = (ClassMapping)classMappingMap.get(parts[1]);
                            String deobName = parts[2].contains("$") ? parts[2].substring(parts[2].lastIndexOf(36) + 1) : parts[2];
                            classMappingMap.put(parts[2], classMapping.setDeobInner(parts[2]));
                            classMapping.setDeobfName(deobName);
                            classMapping.resetDirty();
                        } else {
                            classMapping = this.readClass(parts);
                        }
                        classMappingMap.put(parts[1], classMapping);
                        break;
                    }
                    case "FIELD": {
                        ClassMapping classMapping = classMappingMap.computeIfAbsent(parts[1], k -> new ClassMapping(parts[1]));
                        classMapping.addFieldMapping(this.readField(parts));
                        break;
                    }
                    case "METHOD": {
                        ClassMapping classMapping = classMappingMap.computeIfAbsent(parts[1], k -> new ClassMapping(parts[1]));
                        classMapping.addMethodMapping(this.readMethod(parts));
                        break;
                    }
                    default: {
                        throw new MappingParseException(file, lineNumber, "Unknown token '" + token + "' !");
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                ex.printStackTrace();
                throw new MappingParseException(file, lineNumber, "Malformed line:\n" + line);
            }
        }
        ArrayList toRegister = new ArrayList(classMappingMap.values());
        for (ClassMapping classMapping : toRegister) {
            ClassEntry obEntry = classMapping.getObfEntry();
            ClassEntry deobEntry = classMapping.getDeObfEntry();
            try {
                if (obEntry.isInnerClass()) {
                    ClassMapping parent = (ClassMapping)classMappingMap.get(obEntry.getOuterClassName());
                    if (parent == null) {
                        parent = new ClassMapping(obEntry.getOuterClassName());
                        classMappingMap.put(obEntry.getOuterClassName(), parent);
                        mappings.addClassMapping(parent);
                    }
                    parent.addInnerClassMapping(classMapping);
                    continue;
                }
                if (deobEntry != null && deobEntry.isInnerClass()) {
                    String outerClassName = deobEntry.getOuterClassName();
                    ClassMapping parent = (ClassMapping)classMappingMap.get(outerClassName);
                    if (parent == null && (parent = (ClassMapping)classMappingMap.get(outerClassName)) == null) {
                        parent = new ClassMapping(outerClassName);
                        classMappingMap.put(outerClassName, parent);
                        mappings.addClassMapping(parent);
                    }
                    parent.addInnerClassMapping(classMapping);
                    continue;
                }
                mappings.addClassMapping(classMapping);
            }
            catch (MappingConflict e) {
                throw new MappingParseException(file, -1, e.getMessage());
            }
        }
        lines.clear();
        classMappingMap.clear();
        return mappings;
    }
}

