/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import java.util.List;

public class ProcyonEntryFactory {
    private static String getErasedSignature(MemberReference def) {
        if (!(def instanceof MethodReference)) {
            return def.getErasedSignature();
        }
        MethodReference methodReference = (MethodReference)def;
        StringBuilder builder = new StringBuilder("(");
        for (ParameterDefinition param : methodReference.getParameters()) {
            TypeReference paramType = param.getParameterType();
            if (paramType.getErasedSignature().equals("Ljava/lang/Object;") && paramType.hasExtendsBound() && paramType.getExtendsBound() instanceof CompoundTypeReference) {
                List interfaces = ((CompoundTypeReference)paramType.getExtendsBound()).getInterfaces();
                interfaces.forEach(inter -> builder.append(inter.getErasedSignature()));
                continue;
            }
            builder.append(paramType.getErasedSignature());
        }
        builder.append(")");
        TypeReference returnType = methodReference.getReturnType();
        if (returnType.getErasedSignature().equals("Ljava/lang/Object;") && returnType.hasExtendsBound() && returnType.getExtendsBound() instanceof CompoundTypeReference) {
            List interfaces = ((CompoundTypeReference)returnType.getExtendsBound()).getInterfaces();
            interfaces.forEach(inter -> builder.append(inter.getErasedSignature()));
        } else {
            builder.append(returnType.getErasedSignature());
        }
        return builder.toString();
    }

    public static FieldEntry getFieldEntry(MemberReference def) {
        return new FieldEntry(new ClassEntry(def.getDeclaringType().getInternalName()), def.getName(), new Type(def.getErasedSignature()));
    }

    public static MethodEntry getMethodEntry(MemberReference def) {
        return new MethodEntry(new ClassEntry(def.getDeclaringType().getInternalName()), def.getName(), new Signature(ProcyonEntryFactory.getErasedSignature(def)));
    }

    public static ConstructorEntry getConstructorEntry(MethodReference def) {
        if (def.isTypeInitializer()) {
            return new ConstructorEntry(new ClassEntry(def.getDeclaringType().getInternalName()));
        }
        return new ConstructorEntry(new ClassEntry(def.getDeclaringType().getInternalName()), new Signature(def.getErasedSignature()));
    }

    public static BehaviorEntry getBehaviorEntry(MethodReference def) {
        if (def.isConstructor() || def.isTypeInitializer()) {
            return ProcyonEntryFactory.getConstructorEntry(def);
        }
        return ProcyonEntryFactory.getMethodEntry((MemberReference)def);
    }
}

