/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class Signature {
    private List<Type> argumentTypes;
    private Type returnType;

    public Signature(String signature) {
        try {
            this.argumentTypes = Lists.newArrayList();
            int i = 0;
            while (i < signature.length()) {
                char c = signature.charAt(i);
                if (c == '(') {
                    assert (this.argumentTypes.isEmpty());
                    assert (this.returnType == null);
                    ++i;
                    continue;
                }
                if (c == ')') {
                    ++i;
                    break;
                }
                String type = Type.parseFirst(signature.substring(i));
                this.argumentTypes.add(new Type(type));
                i += type.length();
            }
            this.returnType = new Type(Type.parseFirst(signature.substring(i)));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to parse signature: " + signature, ex);
        }
    }

    public Signature(Signature other, ClassNameReplacer replacer) {
        this.argumentTypes = Lists.newArrayList(other.argumentTypes);
        for (int i = 0; i < this.argumentTypes.size(); ++i) {
            this.argumentTypes.set(i, new Type(this.argumentTypes.get(i), replacer));
        }
        this.returnType = new Type(other.returnType, replacer);
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Type type : this.argumentTypes) {
            buf.append(type);
        }
        buf.append(")");
        buf.append(this.returnType);
        return buf.toString();
    }

    public Iterable<Type> types() {
        ArrayList types = Lists.newArrayList();
        types.addAll(this.argumentTypes);
        types.add(this.returnType);
        return types;
    }

    public boolean equals(Object other) {
        return other instanceof Signature && this.equals((Signature)other);
    }

    public boolean equals(Signature other) {
        return this.argumentTypes.equals(other.argumentTypes) && this.returnType.equals(other.returnType);
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.argumentTypes.hashCode(), this.returnType.hashCode());
    }

    public boolean hasClass(ClassEntry classEntry) {
        for (Type type : this.types()) {
            if (!type.hasClass() || !type.getClassEntry().equals(classEntry)) continue;
            return true;
        }
        return false;
    }
}

