/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import java.util.Map;

public class Type {
    protected String name;

    public Type(String name) {
        if (name.charAt(0) == 'T' || name.indexOf(60) >= 0 || name.indexOf(62) >= 0) {
            throw new IllegalArgumentException("don't use with generic types or templates: " + name);
        }
        this.name = name;
    }

    public Type(Type other, ClassNameReplacer replacer) {
        String replacedName;
        this.name = other.name;
        if (other.isClass()) {
            String replacedName2 = replacer.replace(other.getClassEntry().getClassName());
            if (replacedName2 != null) {
                this.name = "L" + replacedName2 + ";";
            }
        } else if (other.isArray() && other.hasClass() && (replacedName = replacer.replace(other.getClassEntry().getClassName())) != null) {
            this.name = Type.getArrayPrefix(other.getArrayDimension()) + "L" + replacedName + ";";
        }
    }

    public static String parseFirst(String in) {
        if (in == null || in.length() <= 0) {
            throw new IllegalArgumentException("No type to parse, input is empty!");
        }
        char c = in.charAt(0);
        if (c == 'V') {
            return "V";
        }
        Primitive primitive = Primitive.get(c);
        if (primitive != null) {
            return in.substring(0, 1);
        }
        if (c == 'L') {
            return Type.readClass(in);
        }
        if (c == 'T') {
            return Type.readClass(in);
        }
        int dim = Type.countArrayDimension(in);
        if (dim > 0) {
            String arrayType = Type.parseFirst(in.substring(dim));
            return in.substring(0, dim + arrayType.length());
        }
        throw new IllegalArgumentException("don't know how to parse: " + in);
    }

    private static String getArrayPrefix(int dimension) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            buf.append("[");
        }
        return buf.toString();
    }

    private static int countArrayDimension(String in) {
        int i;
        for (i = 0; i < in.length() && in.charAt(i) == '['; ++i) {
        }
        return i;
    }

    private static String readClass(String in) {
        StringBuilder buf = new StringBuilder();
        int depth = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            buf.append(c);
            if (c == '<') {
                ++depth;
                continue;
            }
            if (c == '>') {
                --depth;
                continue;
            }
            if (depth != 0 || c != ';') continue;
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean isVoid() {
        return this.name.length() == 1 && this.name.charAt(0) == 'V';
    }

    public boolean isPrimitive() {
        return this.name.length() == 1 && Primitive.get(this.name.charAt(0)) != null;
    }

    public Primitive getPrimitive() {
        if (!this.isPrimitive()) {
            throw new IllegalStateException("not a primitive");
        }
        return Primitive.get(this.name.charAt(0));
    }

    public boolean isClass() {
        return this.name.charAt(0) == 'L' && this.name.charAt(this.name.length() - 1) == ';';
    }

    public ClassEntry getClassEntry() {
        if (this.isClass()) {
            String name = this.name.substring(1, this.name.length() - 1);
            int pos = name.indexOf(60);
            if (pos >= 0) {
                name = name.substring(0, pos);
            }
            return new ClassEntry(name);
        }
        if (this.isArray() && this.getArrayType().isClass()) {
            return this.getArrayType().getClassEntry();
        }
        throw new IllegalStateException("type doesn't have a class");
    }

    public boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public int getArrayDimension() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return Type.countArrayDimension(this.name);
    }

    public Type getArrayType() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return new Type(this.name.substring(this.getArrayDimension(), this.name.length()));
    }

    public boolean hasClass() {
        return this.isClass() || this.isArray() && this.getArrayType().hasClass();
    }

    public boolean equals(Object other) {
        return other instanceof Type && this.equals((Type)other);
    }

    public boolean equals(Type other) {
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum Primitive {
        Byte('B'),
        Character('C'),
        Short('S'),
        Integer('I'),
        Long('J'),
        Float('F'),
        Double('D'),
        Boolean('Z');

        private static final Map<Character, Primitive> lookup;
        private char code;

        private Primitive(char code) {
            this.code = code;
        }

        public static Primitive get(char code) {
            return lookup.get(java.lang.Character.valueOf(code));
        }

        public char getCode() {
            return this.code;
        }

        static {
            lookup = Maps.newTreeMap();
            for (Primitive val : Primitive.values()) {
                lookup.put(java.lang.Character.valueOf(val.getCode()), val);
            }
        }
    }
}

