/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MethodReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<MethodEntry, MethodDefEntry> {
    private Translator deobfuscatingTranslator;
    private MethodEntry entry;
    private EntryReference<MethodEntry, MethodDefEntry> reference;
    private Access access;

    public MethodReferenceTreeNode(Translator deobfuscatingTranslator, MethodEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    public MethodReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<MethodEntry, MethodDefEntry> reference, Access access) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (MethodEntry)reference.entry;
        this.reference = reference;
        this.access = access;
    }

    @Override
    public MethodEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<MethodEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s (%s)", new Object[]{this.deobfuscatingTranslator.getTranslatedMethodDef((MethodDefEntry)this.reference.context), this.access});
        }
        return this.deobfuscatingTranslator.getTranslatedMethod(this.entry).getName();
    }

    public void load(JarIndex index, boolean recurse) {
        for (EntryReference<MethodEntry, MethodDefEntry> reference : index.getMethodsReferencing(this.entry)) {
            this.add(new MethodReferenceTreeNode(this.deobfuscatingTranslator, reference, index.getAccess(this.entry)));
        }
        if (recurse && this.children != null) {
            for (EntryReference<MethodEntry, MethodDefEntry> child : this.children) {
                if (!(child instanceof MethodReferenceTreeNode)) continue;
                MethodReferenceTreeNode node = (MethodReferenceTreeNode)((Object)child);
                HashSet ancestors = Sets.newHashSet();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof MethodReferenceTreeNode)) continue;
                    ancestors.add(((MethodReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true);
            }
        }
    }
}

