/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.mapping.entry.ClassEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ParsedJar {
    private final Map<String, ClassNode> nodes = new LinkedHashMap<String, ClassNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedJar(JarFile jar) throws IOException {
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
                Throwable throwable = null;
                try {
                    ClassReader reader = new ClassReader((InputStream)input);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 0);
                    String path = entry.getName().substring(0, entry.getName().length() - ".class".length());
                    this.nodes.put(path, node);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedJar(JarInputStream jar) throws IOException {
        try {
            JarEntry entry;
            while ((entry = jar.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                ClassReader reader = new ClassReader((InputStream)jar);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                String path = entry.getName().substring(0, entry.getName().length() - ".class".length());
                this.nodes.put(path, node);
                jar.closeEntry();
            }
        }
        finally {
            jar.close();
        }
    }

    public void visit(Consumer<ClassNode> visitor) {
        for (ClassNode node : this.nodes.values()) {
            visitor.accept(node);
        }
    }

    public int getClassCount() {
        return this.nodes.size();
    }

    public List<ClassEntry> getClassEntries() {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(this.nodes.size());
        for (ClassNode node : this.nodes.values()) {
            entries.add(new ClassEntry(node.name));
        }
        return entries;
    }

    public ClassNode getClassNode(String name) {
        return this.nodes.get(name);
    }
}

