/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class Config {
    private static final File DIR_HOME = new File(System.getProperty("user.home"));
    private static final File ENIGMA_DIR = new File(DIR_HOME, ".enigma");
    private static final File CONFIG_FILE = new File(ENIGMA_DIR, "config.json");
    private static final Config INSTANCE = new Config();
    private final transient Gson gson = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntSerializer()).registerTypeAdapter(Integer.class, (Object)new IntDeserializer()).registerTypeAdapter(Config.class, type -> this).setPrettyPrinting().create();
    public Integer obfuscatedColor;
    public float obfuscatedHiglightAlpha;
    public Integer obfuscatedColorOutline;
    public float obfuscatedOutlineAlpha;
    public Integer deobfuscatedColor;
    public float deobfuscatedHiglightAlpha;
    public Integer deobfuscatedColorOutline;
    public float deobfuscatedOutlineAlpha;
    public Integer otherColorOutline;
    public float otherOutlineAlpha;
    public Integer editorBackground;
    public Integer highlightColor;
    public Integer stringColor;
    public Integer numberColor;
    public Integer operatorColor;
    public Integer delimiterColor;
    public Integer typeColor;
    public Integer identifierColor;
    public Integer defaultTextColor;
    public boolean useSystemLAF = true;

    private Config() {
        try {
            this.loadConfig();
        }
        catch (IOException ignored) {
            try {
                this.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void loadConfig() throws IOException {
        File configFile;
        if (!ENIGMA_DIR.exists()) {
            ENIGMA_DIR.mkdirs();
        }
        if ((configFile = new File(ENIGMA_DIR, "config.json")).exists()) {
            this.gson.fromJson(Files.asCharSource((File)configFile, (Charset)Charset.defaultCharset()).read(), Config.class);
        } else {
            this.reset();
            Files.touch((File)configFile);
        }
        this.saveConfig();
    }

    public void saveConfig() throws IOException {
        Files.asCharSink((File)CONFIG_FILE, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.gson.toJson((Object)this));
    }

    public void reset() throws IOException {
        this.obfuscatedColor = 0xFFDCDC;
        this.obfuscatedHiglightAlpha = 1.0f;
        this.obfuscatedColorOutline = 0xA05050;
        this.obfuscatedOutlineAlpha = 1.0f;
        this.deobfuscatedColor = 0xDCFFDC;
        this.deobfuscatedHiglightAlpha = 1.0f;
        this.deobfuscatedColorOutline = 0x50A050;
        this.deobfuscatedOutlineAlpha = 1.0f;
        this.otherColorOutline = 0xB4B4B4;
        this.otherOutlineAlpha = 1.0f;
        this.editorBackground = 0xFFFFFF;
        this.highlightColor = 0x3333EE;
        this.stringColor = 0xCC6600;
        this.numberColor = 0x999933;
        this.operatorColor = 0;
        this.delimiterColor = 0;
        this.typeColor = 0;
        this.identifierColor = 0;
        this.defaultTextColor = 0;
        this.useSystemLAF = true;
        this.saveConfig();
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    private static class IntDeserializer
    implements JsonDeserializer<Integer> {
        private IntDeserializer() {
        }

        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            return (int)Long.parseLong(json.getAsString().replace("#", ""), 16);
        }
    }

    private static class IntSerializer
    implements JsonSerializer<Integer> {
        private IntSerializer() {
        }

        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive("#" + Integer.toHexString(src).toUpperCase());
        }
    }
}

