/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.base.Charsets;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.LocalVariableMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MappingsEnigmaWriter {
    public void write(File out, Mappings mappings, boolean isDirectoryFormat) throws IOException {
        if (!isDirectoryFormat) {
            PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charsets.UTF_8));
            this.write(outputWriter, mappings);
            outputWriter.close();
        } else {
            this.writeAsDirectory(out, mappings);
        }
    }

    public void writeAsDirectory(File target, Mappings mappings) throws IOException {
        if (!target.exists() && !target.mkdirs()) {
            throw new IOException("Cannot create mapping directory!");
        }
        Mappings previousState = mappings.getPreviousState();
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            File result;
            File packageFile;
            ClassMapping previousClass;
            File previousFile;
            if (!classMapping.isDirty()) continue;
            if (previousState != null && (previousFile = (previousClass = previousState.classesByObf.get(classMapping.getObfFullName())) != null ? new File(target, previousClass.getSaveName() + ".mapping") : new File(target, classMapping.getObfFullName() + ".mapping")).exists() && !previousFile.delete()) {
                System.err.println("Failed to delete old class mapping " + previousFile.getName());
            }
            if (!(packageFile = (result = new File(target, classMapping.getSaveName() + ".mapping")).getParentFile()).exists()) {
                packageFile.mkdirs();
            }
            result.createNewFile();
            PrintWriter outputWriter = new PrintWriter(new BufferedWriter(new FileWriter(result)));
            Throwable throwable = null;
            try {
                this.write(outputWriter, classMapping, 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (outputWriter == null) continue;
                if (throwable != null) {
                    try {
                        outputWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                outputWriter.close();
            }
        }
        if (previousState != null) {
            HashSet<ClassMapping> droppedClassMappings = new HashSet<ClassMapping>(previousState.classes());
            droppedClassMappings.removeAll(mappings.classes());
            for (ClassMapping droppedMapping : droppedClassMappings) {
                File result = new File(target, droppedMapping.getSaveName() + ".mapping");
                if (!result.exists() || result.delete()) continue;
                System.err.println("Failed to delete dropped class mapping " + result.getName());
            }
        }
    }

    public void write(PrintWriter out, Mappings mappings) throws IOException {
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            this.write(out, classMapping, 0);
        }
    }

    protected void write(PrintWriter out, ClassMapping classMapping, int depth) throws IOException {
        if (classMapping.getDeobfName() == null) {
            out.format("%sCLASS %s%s\n", this.getIndent(depth), classMapping.getObfFullName(), classMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : classMapping.getModifier().getFormattedName());
        } else {
            out.format("%sCLASS %s %s%s\n", this.getIndent(depth), classMapping.getObfFullName(), classMapping.getDeobfName(), classMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : classMapping.getModifier().getFormattedName());
        }
        for (ClassMapping innerClassMapping : this.sorted(classMapping.innerClasses())) {
            this.write(out, innerClassMapping, depth + 1);
        }
        for (FieldMapping fieldMapping : this.sorted(classMapping.fields())) {
            this.write(out, fieldMapping, depth + 1);
        }
        for (MethodMapping methodMapping : this.sorted(classMapping.methods())) {
            this.write(out, methodMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, FieldMapping fieldMapping, int depth) {
        if (fieldMapping.getDeobfName() == null) {
            out.format("%sFIELD %s %s%s\n", this.getIndent(depth), fieldMapping.getObfName(), fieldMapping.getObfDesc().toString(), fieldMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : fieldMapping.getModifier().getFormattedName());
        } else {
            out.format("%sFIELD %s %s %s%s\n", this.getIndent(depth), fieldMapping.getObfName(), fieldMapping.getDeobfName(), fieldMapping.getObfDesc().toString(), fieldMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : fieldMapping.getModifier().getFormattedName());
        }
    }

    private void write(PrintWriter out, MethodMapping methodMapping, int depth) throws IOException {
        if (methodMapping.isObfuscated()) {
            out.format("%sMETHOD %s %s%s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getObfDesc(), methodMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : methodMapping.getModifier().getFormattedName());
        } else {
            out.format("%sMETHOD %s %s %s%s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getDeobfName(), methodMapping.getObfDesc(), methodMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : methodMapping.getModifier().getFormattedName());
        }
        for (LocalVariableMapping localVariableMapping : this.sorted(methodMapping.arguments())) {
            this.write(out, localVariableMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, LocalVariableMapping localVariableMapping, int depth) {
        out.format("%sARG %d %s\n", this.getIndent(depth), localVariableMapping.getIndex(), localVariableMapping.getName());
    }

    protected <T extends Comparable<T>> List<T> sorted(Iterable<T> classes) {
        ArrayList<Comparable> out = new ArrayList<Comparable>();
        for (Comparable t : classes) {
            out.add(t);
        }
        Collections.sort(out);
        return out;
    }

    private String getIndent(int depth) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("\t");
        }
        return buf.toString();
    }
}

