/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.LocalVariableMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.throwables.MappingConflict;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class MappingsRenamer {
    private final JarIndex index;
    private final ReferencedEntryPool entryPool;
    private Mappings mappings;

    public MappingsRenamer(JarIndex index, Mappings mappings, ReferencedEntryPool entryPool) {
        this.index = index;
        this.mappings = mappings;
        this.entryPool = entryPool;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setClassName(ClassEntry obf, String deobfName) {
        deobfName = NameValidator.validateClassName(deobfName, !obf.isInnerClass());
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            if (deobfName != null && (this.mappings.containsDeobfClass(deobfName) || this.index.containsObfClass(this.entryPool.getClass(deobfName)))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            ClassMapping classMapping = mappingChain.get(0);
            this.mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            if (deobfName != null && (outerClassMapping.hasInnerClassByDeobf(deobfName) || outerClassMapping.hasInnerClassByObfSimple(deobfName))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void removeClassMapping(ClassEntry obf) {
        this.setClassName(obf, null);
    }

    public void markClassAsDeobfuscated(ClassEntry obf) {
        String deobfName = obf.isInnerClass() ? obf.getInnermostClassName() : obf.getName();
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            ClassMapping classMapping = mappingChain.get(0);
            this.mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void setFieldName(FieldEntry obf, String deobfName) {
        deobfName = NameValidator.validateFieldName(deobfName);
        FieldEntry targetEntry = this.entryPool.getField(obf.getOwnerClassEntry(), deobfName, obf.getDesc());
        ClassEntry definedClass = null;
        if (this.mappings.containsDeobfField(obf.getOwnerClassEntry(), deobfName) || this.index.containsEntryWithSameName(targetEntry)) {
            definedClass = obf.getOwnerClassEntry();
        } else {
            for (ClassEntry ancestorEntry : this.index.getTranslationIndex().getAncestry(obf.getOwnerClassEntry())) {
                if (!this.mappings.containsDeobfField(ancestorEntry, deobfName) && !this.index.containsEntryWithSameName(targetEntry.updateOwnership(ancestorEntry))) continue;
                definedClass = ancestorEntry;
                break;
            }
        }
        if (definedClass != null) {
            Translator translator = this.mappings.getTranslator(TranslationDirection.DEOBFUSCATING, this.index.getTranslationIndex());
            String className = translator.getTranslatedClass(this.entryPool.getClass(definedClass.getClassName())).getName();
            if (className == null) {
                className = definedClass.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a field with that name in " + className);
        }
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getDesc(), deobfName);
    }

    public void removeFieldMapping(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.removeFieldMapping(classMapping.getFieldByObf(obf.getName(), obf.getDesc()));
    }

    public void markFieldAsDeobfuscated(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getDesc(), obf.getName());
    }

    private void validateMethodTreeName(MethodEntry entry, String deobfName) {
        MethodEntry targetEntry = this.entryPool.getMethod(entry.getOwnerClassEntry(), deobfName, entry.getDesc());
        ClassMapping classMapping = this.mappings.getClassByObf(entry.getOwnerClassEntry());
        if (classMapping != null && classMapping.containsDeobfMethod(deobfName, entry.getDesc()) && classMapping.getMethodByObf(entry.getName(), entry.getDesc()) != classMapping.getMethodByDeobf(deobfName, entry.getDesc()) || this.index.containsObfMethod(targetEntry)) {
            Translator translator = this.mappings.getTranslator(TranslationDirection.DEOBFUSCATING, this.index.getTranslationIndex());
            String deobfClassName = translator.getTranslatedClass(this.entryPool.getClass(entry.getClassName())).getClassName();
            if (deobfClassName == null) {
                deobfClassName = entry.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        for (ClassEntry child : this.index.getTranslationIndex().getSubclass(entry.getOwnerClassEntry())) {
            this.validateMethodTreeName(entry.updateOwnership(child), deobfName);
        }
    }

    public void setMethodTreeName(MethodEntry obf, String deobfName) {
        Set<MethodEntry> implementations = this.index.getRelatedMethodImplementations(obf);
        deobfName = NameValidator.validateMethodName(deobfName);
        for (MethodEntry entry : implementations) {
            this.validateMethodTreeName(entry, deobfName);
        }
        for (MethodEntry entry : implementations) {
            this.setMethodName(entry, deobfName);
        }
    }

    public void setMethodName(MethodEntry obf, String deobfName) {
        deobfName = NameValidator.validateMethodName(deobfName);
        MethodEntry targetEntry = this.entryPool.getMethod(obf.getOwnerClassEntry(), deobfName, obf.getDesc());
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        if (this.mappings.containsDeobfMethod(obf.getOwnerClassEntry(), deobfName, obf.getDesc()) && classMapping.getMethodByObf(obf.getName(), obf.getDesc()) != classMapping.getMethodByDeobf(deobfName, obf.getDesc()) || this.index.containsObfMethod(targetEntry)) {
            Translator translator = this.mappings.getTranslator(TranslationDirection.DEOBFUSCATING, this.index.getTranslationIndex());
            String deobfClassName = translator.getTranslatedClass(this.entryPool.getClass(obf.getClassName())).getClassName();
            if (deobfClassName == null) {
                deobfClassName = obf.getClassName();
            }
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        classMapping.setMethodName(obf.getName(), obf.getDesc(), deobfName);
    }

    public void removeMethodTreeMapping(MethodEntry obf) {
        this.index.getRelatedMethodImplementations(obf).forEach(this::removeMethodMapping);
    }

    public void removeMethodMapping(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getDesc(), null);
    }

    public void markMethodTreeAsDeobfuscated(MethodEntry obf) {
        this.index.getRelatedMethodImplementations(obf).forEach(this::markMethodAsDeobfuscated);
    }

    public void markMethodAsDeobfuscated(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getDesc(), obf.getName());
    }

    public void setLocalVariableTreeName(LocalVariableEntry obf, String deobfName) {
        MethodEntry obfMethod = obf.getOwnerEntry();
        Set<MethodEntry> implementations = this.index.getRelatedMethodImplementations(obfMethod);
        for (MethodEntry entry : implementations) {
            MethodMapping mapping;
            ClassMapping classMapping = this.mappings.getClassByObf(entry.getOwnerClassEntry());
            if (classMapping == null || (mapping = classMapping.getMethodByObf(entry.getName(), entry.getDesc())) == null) continue;
            for (LocalVariableMapping localVariableMapping : Lists.newArrayList(mapping.arguments())) {
                if (localVariableMapping.getIndex() == obf.getIndex() || !mapping.getDeobfLocalVariableName(localVariableMapping.getIndex()).equals(deobfName) && !localVariableMapping.getName().equals(deobfName)) continue;
                throw new IllegalNameException(deobfName, "There is already an argument with that name");
            }
        }
        for (MethodEntry entry : implementations) {
            this.setLocalVariableName(new LocalVariableEntry(entry, obf.getIndex(), obf.getName()), deobfName);
        }
    }

    public void setLocalVariableName(LocalVariableEntry obf, String deobfName) {
        deobfName = NameValidator.validateArgumentName(deobfName);
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        MethodMapping mapping = classMapping.getMethodByObf(obf.getMethodName(), obf.getMethodDesc());
        if (mapping != null) {
            for (LocalVariableMapping localVariableMapping : Lists.newArrayList(mapping.arguments())) {
                if (localVariableMapping.getIndex() == obf.getIndex() || !mapping.getDeobfLocalVariableName(localVariableMapping.getIndex()).equals(deobfName) && !localVariableMapping.getName().equals(deobfName)) continue;
                throw new IllegalNameException(deobfName, "There is already an argument with that name");
            }
        }
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodDesc(), obf.getIndex(), deobfName);
    }

    public void removeLocalVariableMapping(LocalVariableEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.removeArgumentName(obf.getMethodName(), obf.getMethodDesc(), obf.getIndex());
    }

    public void markArgumentAsDeobfuscated(LocalVariableEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getOwnerClassEntry());
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodDesc(), obf.getIndex(), obf.getName());
    }

    public boolean moveFieldToObfClass(ClassMapping classMapping, FieldMapping fieldMapping, ClassEntry obfClass) {
        classMapping.removeFieldMapping(fieldMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfField(fieldMapping.getObfName(), fieldMapping.getObfDesc())) {
            if (!targetClassMapping.containsDeobfField(fieldMapping.getDeobfName(), fieldMapping.getObfDesc())) {
                targetClassMapping.addFieldMapping(fieldMapping);
                return true;
            }
            System.err.println("WARNING: deobf field was already there: " + obfClass + "." + fieldMapping.getDeobfName());
        }
        return false;
    }

    public boolean moveMethodToObfClass(ClassMapping classMapping, MethodMapping methodMapping, ClassEntry obfClass) {
        classMapping.removeMethodMapping(methodMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfMethod(methodMapping.getObfName(), methodMapping.getObfDesc())) {
            if (!targetClassMapping.containsDeobfMethod(methodMapping.getDeobfName(), methodMapping.getObfDesc())) {
                targetClassMapping.addMethodMapping(methodMapping);
                return true;
            }
            System.err.println("WARNING: deobf method was already there: " + obfClass + "." + methodMapping.getDeobfName() + methodMapping.getObfDesc());
        }
        return false;
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this);
        gzipout.finish();
    }

    private ClassMapping getOrCreateClassMapping(ClassEntry obfClassEntry) {
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obfClassEntry);
        return mappingChain.get(mappingChain.size() - 1);
    }

    private List<ClassMapping> getOrCreateClassMappingChain(ClassEntry obfClassEntry) {
        List<ClassEntry> classChain = obfClassEntry.getClassChain();
        List<ClassMapping> mappingChain = this.mappings.getClassMappingChain(obfClassEntry);
        for (int i = 0; i < classChain.size(); ++i) {
            ClassEntry classEntry = classChain.get(i);
            ClassMapping classMapping = mappingChain.get(i);
            if (classMapping != null) continue;
            classMapping = new ClassMapping(classEntry.getName());
            mappingChain.set(i, classMapping);
            try {
                if (i == 0) {
                    this.mappings.addClassMapping(classMapping);
                    continue;
                }
                mappingChain.get(i - 1).addInnerClassMapping(classMapping);
                continue;
            }
            catch (MappingConflict mappingConflict) {
                mappingConflict.printStackTrace();
            }
        }
        return mappingChain;
    }

    public void setClassModifier(ClassEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry);
        classMapping.setModifier(modifier);
    }

    public void setFieldModifier(FieldEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry.getOwnerClassEntry());
        classMapping.setFieldModifier(obEntry.getName(), obEntry.getDesc(), modifier);
    }

    public void setMethodModifier(MethodEntry obEntry, Mappings.EntryModifier modifier) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obEntry.getOwnerClassEntry());
        classMapping.setMethodModifier(obEntry.getName(), obEntry.getDesc(), modifier);
    }

    public Mappings.EntryModifier getClassModifier(ClassEntry obfEntry) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obfEntry);
        return classMapping.getModifier();
    }

    public Mappings.EntryModifier getFieldModifier(FieldEntry obfEntry) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obfEntry.getOwnerClassEntry());
        FieldMapping fieldMapping = classMapping.getFieldByObf(obfEntry);
        if (fieldMapping == null) {
            return Mappings.EntryModifier.UNCHANGED;
        }
        return fieldMapping.getModifier();
    }

    public Mappings.EntryModifier getMethodModfifier(MethodEntry obfEntry) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obfEntry.getOwnerClassEntry());
        MethodMapping methodMapping = classMapping.getMethodByObf(obfEntry);
        if (methodMapping == null) {
            return Mappings.EntryModifier.UNCHANGED;
        }
        return methodMapping.getModifier();
    }
}

