/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.utils.Utils;

public class LocalVariableEntry
implements Entry {
    protected final MethodEntry ownerEntry;
    protected final String name;
    protected final int index;

    public LocalVariableEntry(MethodEntry ownerEntry, int index, String name) {
        Preconditions.checkNotNull((Object)ownerEntry, (Object)"Variable owner cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Variable name cannot be null");
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Index must be positive");
        this.ownerEntry = ownerEntry;
        this.name = name;
        this.index = index;
    }

    public MethodEntry getOwnerEntry() {
        return this.ownerEntry;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClassEntry getOwnerClassEntry() {
        return this.ownerEntry.getOwnerClassEntry();
    }

    @Override
    public String getClassName() {
        return this.ownerEntry.getClassName();
    }

    @Override
    public LocalVariableEntry updateOwnership(ClassEntry classEntry) {
        return new LocalVariableEntry(this.ownerEntry.updateOwnership(classEntry), this.index, this.name);
    }

    public String getMethodName() {
        return this.ownerEntry.getName();
    }

    public MethodDescriptor getMethodDesc() {
        return this.ownerEntry.getDesc();
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.ownerEntry, this.name.hashCode(), Integer.hashCode(this.index));
    }

    public boolean equals(Object other) {
        return other instanceof LocalVariableEntry && this.equals((LocalVariableEntry)other);
    }

    public boolean equals(LocalVariableEntry other) {
        return this.ownerEntry.equals(other.ownerEntry) && this.name.equals(other.name) && this.index == other.index;
    }

    public String toString() {
        return this.ownerEntry + "(" + this.index + ":" + this.name + ")";
    }
}

