/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.utils.Utils;

public class MethodEntry
implements Entry {
    protected final ClassEntry classEntry;
    protected final String name;
    protected final MethodDescriptor descriptor;

    public MethodEntry(ClassEntry classEntry, String name, MethodDescriptor descriptor) {
        Preconditions.checkNotNull((Object)classEntry, (Object)"Class cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Method name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Method descriptor cannot be null");
        this.classEntry = classEntry;
        this.name = name;
        this.descriptor = descriptor;
    }

    @Override
    public ClassEntry getOwnerClassEntry() {
        return this.classEntry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MethodDescriptor getDesc() {
        return this.descriptor;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>") || this.name.equals("<clinit>");
    }

    @Override
    public String getClassName() {
        return this.classEntry.getName();
    }

    @Override
    public MethodEntry updateOwnership(ClassEntry classEntry) {
        return new MethodEntry(new ClassEntry(classEntry.getName()), this.name, this.descriptor);
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.classEntry, this.name, this.descriptor);
    }

    public boolean equals(Object other) {
        return other instanceof MethodEntry && this.equals((MethodEntry)other);
    }

    public boolean equals(MethodEntry other) {
        return this.classEntry.equals(other.getOwnerClassEntry()) && this.name.equals(other.getName()) && this.descriptor.equals(other.getDesc());
    }

    public String toString() {
        return this.classEntry.getName() + "." + this.name + this.descriptor;
    }
}

