/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.analysis.IndexClassVisitor;
import cuchaz.enigma.analysis.IndexInnerClassVisitor;
import cuchaz.enigma.analysis.IndexReferenceVisitor;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.DirectionalTranslator;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;

public class JarIndex {
    private final ReferencedEntryPool entryPool;
    private Set<ClassEntry> obfClassEntries;
    private TranslationIndex translationIndex;
    private Map<Entry, Access> access;
    private Multimap<ClassEntry, FieldDefEntry> fields;
    private Multimap<ClassEntry, MethodDefEntry> methods;
    private Multimap<String, MethodDefEntry> methodImplementations;
    private Multimap<MethodEntry, EntryReference<MethodEntry, MethodDefEntry>> methodsReferencing;
    private Multimap<MethodEntry, MethodEntry> methodReferences;
    private Multimap<FieldEntry, EntryReference<FieldEntry, MethodDefEntry>> fieldReferences;
    private Multimap<ClassEntry, ClassEntry> innerClassesByOuter;
    private Map<ClassEntry, ClassEntry> outerClassesByInner;
    private Map<MethodEntry, MethodEntry> bridgedMethods;
    private Set<MethodEntry> syntheticMethods;

    public JarIndex(ReferencedEntryPool entryPool) {
        this.entryPool = entryPool;
        this.obfClassEntries = Sets.newHashSet();
        this.translationIndex = new TranslationIndex(entryPool);
        this.access = Maps.newHashMap();
        this.fields = HashMultimap.create();
        this.methods = HashMultimap.create();
        this.methodImplementations = HashMultimap.create();
        this.methodsReferencing = HashMultimap.create();
        this.methodReferences = HashMultimap.create();
        this.fieldReferences = HashMultimap.create();
        this.innerClassesByOuter = HashMultimap.create();
        this.outerClassesByInner = Maps.newHashMap();
        this.bridgedMethods = Maps.newHashMap();
        this.syntheticMethods = Sets.newHashSet();
    }

    public void indexJar(ParsedJar jar, boolean buildInnerClasses) {
        this.obfClassEntries.addAll(jar.getClassEntries());
        jar.visit(node -> node.accept((ClassVisitor)new IndexClassVisitor(this, 327680)));
        jar.visit(node -> node.accept((ClassVisitor)new IndexReferenceVisitor(this, 327680)));
        for (MethodDefEntry methodEntry : this.methods.values()) {
            MethodEntry accessedMethod = this.findAccessMethod(methodEntry);
            if (accessedMethod == null || !this.isBridgedMethod(accessedMethod, methodEntry)) continue;
            this.bridgedMethods.put(methodEntry, accessedMethod);
        }
        if (buildInnerClasses) {
            jar.visit(node -> node.accept((ClassVisitor)new IndexInnerClassVisitor(this, 327680)));
            HashMap renames = Maps.newHashMap();
            for (ClassEntry innerClassEntry : this.innerClassesByOuter.values()) {
                String newName = innerClassEntry.buildClassEntry(this.getObfClassChain(innerClassEntry)).getName();
                if (innerClassEntry.getName().equals(newName)) continue;
                renames.put(innerClassEntry.getName(), newName);
            }
            EntryRenamer.renameClassesInSet(renames, this.obfClassEntries);
            this.translationIndex.renameClasses(renames);
            EntryRenamer.renameClassesInMultimap(renames, this.methodImplementations);
            EntryRenamer.renameClassesInMultimap(renames, this.methodsReferencing);
            EntryRenamer.renameClassesInMultimap(renames, this.methodReferences);
            EntryRenamer.renameClassesInMultimap(renames, this.fieldReferences);
            EntryRenamer.renameClassesInMap(renames, this.access);
        }
    }

    protected ClassDefEntry indexClass(int access, String name, String signature, String superName, String[] interfaces) {
        for (String interfaceName : interfaces) {
            if (!name.equals(interfaceName)) continue;
            throw new IllegalArgumentException("Class cannot be its own interface! " + name);
        }
        return this.translationIndex.indexClass(access, name, signature, superName, interfaces);
    }

    protected void indexField(ClassDefEntry owner, int access, String name, String desc, String signature) {
        FieldDefEntry fieldEntry = new FieldDefEntry(owner, name, new TypeDescriptor(desc), Signature.createTypedSignature(signature), new AccessFlags(access));
        this.translationIndex.indexField(fieldEntry);
        this.access.put(fieldEntry, Access.get(access));
        this.fields.put((Object)fieldEntry.getOwnerClassEntry(), (Object)fieldEntry);
    }

    protected void indexMethod(ClassDefEntry owner, int access, String name, String desc, String signature) {
        MethodDefEntry methodEntry = new MethodDefEntry(owner, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        this.translationIndex.indexMethod(methodEntry);
        this.access.put(methodEntry, Access.get(access));
        this.methods.put((Object)methodEntry.getOwnerClassEntry(), (Object)methodEntry);
        if (new AccessFlags(access).isSynthetic()) {
            this.syntheticMethods.add(methodEntry);
        }
        if (!methodEntry.isConstructor()) {
            this.methodImplementations.put((Object)methodEntry.getClassName(), (Object)methodEntry);
        }
    }

    protected void indexMethodCall(MethodDefEntry callerEntry, String owner, String name, String desc) {
        MethodEntry referencedMethod = new MethodEntry(this.entryPool.getClass(owner), name, new MethodDescriptor(desc));
        ClassEntry resolvedClassEntry = this.translationIndex.resolveEntryOwner(referencedMethod);
        if (resolvedClassEntry != null && !resolvedClassEntry.equals(referencedMethod.getOwnerClassEntry())) {
            referencedMethod = referencedMethod.updateOwnership(resolvedClassEntry);
        }
        this.methodsReferencing.put((Object)referencedMethod, new EntryReference<MethodEntry, MethodDefEntry>(referencedMethod, referencedMethod.getName(), callerEntry));
        this.methodReferences.put((Object)callerEntry, (Object)referencedMethod);
    }

    protected void indexFieldAccess(MethodDefEntry callerEntry, String owner, String name, String desc) {
        FieldEntry referencedField = new FieldEntry(this.entryPool.getClass(owner), name, new TypeDescriptor(desc));
        ClassEntry resolvedClassEntry = this.translationIndex.resolveEntryOwner(referencedField);
        if (resolvedClassEntry != null && !resolvedClassEntry.equals(referencedField.getOwnerClassEntry())) {
            referencedField = referencedField.updateOwnership(resolvedClassEntry);
        }
        this.fieldReferences.put((Object)referencedField, new EntryReference<FieldEntry, MethodDefEntry>(referencedField, referencedField.getName(), callerEntry));
    }

    public void indexInnerClass(ClassEntry innerEntry, ClassEntry outerEntry) {
        this.innerClassesByOuter.put((Object)outerEntry, (Object)innerEntry);
        this.outerClassesByInner.putIfAbsent(innerEntry, outerEntry);
    }

    private MethodEntry findAccessMethod(MethodDefEntry method) {
        if (!method.getAccess().isSynthetic()) {
            return null;
        }
        Collection referencedMethods = this.methodReferences.get((Object)method);
        if (referencedMethods.size() != 1) {
            return null;
        }
        return referencedMethods.stream().findFirst().orElse(null);
    }

    private boolean isBridgedMethod(MethodEntry called, MethodEntry access) {
        if (!called.getName().equals(access.getName()) || called.getDesc().getArgumentDescs().size() != access.getDesc().getArgumentDescs().size()) {
            return false;
        }
        TypeDescriptor accessReturn = access.getDesc().getReturnDesc();
        TypeDescriptor calledReturn = called.getDesc().getReturnDesc();
        if (calledReturn.isVoid() || calledReturn.isPrimitive() || accessReturn.isVoid() || accessReturn.isPrimitive()) {
            return false;
        }
        if (accessReturn.equals(calledReturn)) {
            return false;
        }
        String accessType = accessReturn.toString();
        if (accessType.equals("Ljava/lang/Object;")) {
            return true;
        }
        List<ClassEntry> calledAncestry = this.translationIndex.getAncestry(calledReturn.getTypeEntry());
        return calledAncestry.contains(accessReturn.getTypeEntry());
    }

    public Set<ClassEntry> getObfClassEntries() {
        return this.obfClassEntries;
    }

    public Collection<FieldDefEntry> getObfFieldEntries() {
        return this.fields.values();
    }

    public Collection<FieldDefEntry> getObfFieldEntries(ClassEntry classEntry) {
        return this.fields.get((Object)classEntry);
    }

    public Collection<MethodDefEntry> getObfBehaviorEntries() {
        return this.methods.values();
    }

    public Collection<MethodDefEntry> getObfBehaviorEntries(ClassEntry classEntry) {
        return this.methods.get((Object)classEntry);
    }

    public TranslationIndex getTranslationIndex() {
        return this.translationIndex;
    }

    public Access getAccess(Entry entry) {
        return this.access.get(entry);
    }

    public ClassInheritanceTreeNode getClassInheritance(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        ArrayList ancestry = Lists.newArrayList();
        ancestry.add(obfClassEntry.getName());
        for (ClassEntry classEntry : this.translationIndex.getAncestry(obfClassEntry)) {
            if (!this.containsObfClass(classEntry)) continue;
            ancestry.add(classEntry.getName());
        }
        ClassInheritanceTreeNode rootNode = new ClassInheritanceTreeNode(deobfuscatingTranslator, (String)ancestry.get(ancestry.size() - 1));
        rootNode.load(this.translationIndex, true);
        return rootNode;
    }

    public ClassImplementationsTreeNode getClassImplementations(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        if (this.isInterface(obfClassEntry.getClassName())) {
            ClassImplementationsTreeNode node = new ClassImplementationsTreeNode(deobfuscatingTranslator, obfClassEntry);
            node.load(this);
            return node;
        }
        return null;
    }

    public MethodInheritanceTreeNode getMethodInheritance(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        LinkedList<ClassEntry> entries = new LinkedList<ClassEntry>();
        entries.add(obfMethodEntry.getOwnerClassEntry());
        ClassEntry baseImplementationClassEntry = obfMethodEntry.getOwnerClassEntry();
        for (ClassEntry itf : this.getInterfaces(obfMethodEntry.getOwnerClassEntry().getClassName())) {
            MethodEntry itfMethodEntry = this.entryPool.getMethod(itf, obfMethodEntry.getName(), obfMethodEntry.getDesc().toString());
            if (itfMethodEntry == null || !this.containsObfMethod(itfMethodEntry)) continue;
            baseImplementationClassEntry = itf;
        }
        for (ClassEntry ancestorClassEntry : this.translationIndex.getAncestry((ClassEntry)entries.remove())) {
            MethodEntry ancestorMethodEntry = this.entryPool.getMethod(ancestorClassEntry, obfMethodEntry.getName(), obfMethodEntry.getDesc().toString());
            if (ancestorMethodEntry == null) continue;
            if (this.containsObfMethod(ancestorMethodEntry)) {
                baseImplementationClassEntry = ancestorClassEntry;
            }
            for (ClassEntry itf : this.getInterfaces(ancestorClassEntry.getClassName())) {
                MethodEntry itfMethodEntry = this.entryPool.getMethod(itf, obfMethodEntry.getName(), obfMethodEntry.getDesc().toString());
                if (itfMethodEntry == null || !this.containsObfMethod(itfMethodEntry)) continue;
                baseImplementationClassEntry = itf;
            }
        }
        MethodEntry methodEntry = this.entryPool.getMethod(baseImplementationClassEntry, obfMethodEntry.getName(), obfMethodEntry.getDesc().toString());
        MethodInheritanceTreeNode rootNode = new MethodInheritanceTreeNode(deobfuscatingTranslator, methodEntry, this.containsObfMethod(methodEntry));
        rootNode.load(this, true);
        return rootNode;
    }

    public List<MethodImplementationsTreeNode> getMethodImplementations(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        ArrayList interfaceMethodEntries = Lists.newArrayList();
        if (this.isInterface(obfMethodEntry.getClassName())) {
            interfaceMethodEntries.add(obfMethodEntry);
        } else {
            for (ClassEntry interfaceEntry : this.getInterfaces(obfMethodEntry.getClassName())) {
                MethodEntry methodInterface = this.entryPool.getMethod(interfaceEntry, obfMethodEntry.getName(), obfMethodEntry.getDesc().toString());
                if (methodInterface == null || !this.containsObfMethod(methodInterface)) continue;
                interfaceMethodEntries.add(methodInterface);
            }
        }
        ArrayList nodes = Lists.newArrayList();
        if (!interfaceMethodEntries.isEmpty()) {
            for (MethodEntry interfaceMethodEntry : interfaceMethodEntries) {
                MethodImplementationsTreeNode node = new MethodImplementationsTreeNode(deobfuscatingTranslator, interfaceMethodEntry);
                node.load(this);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public Set<MethodEntry> getRelatedMethodImplementations(MethodEntry obfMethodEntry) {
        HashSet methodEntries = Sets.newHashSet();
        this.getRelatedMethodImplementations((Set<MethodEntry>)methodEntries, this.getMethodInheritance(new DirectionalTranslator(this.entryPool), obfMethodEntry));
        return methodEntries;
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodInheritanceTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (methodEntries.contains(methodEntry)) {
            return;
        }
        if (this.containsObfMethod(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedMethod = this.getBridgedMethod(methodEntry);
        while (bridgedMethod != null) {
            methodEntries.addAll(this.getRelatedMethodImplementations(bridgedMethod));
            bridgedMethod = this.getBridgedMethod(bridgedMethod);
        }
        for (MethodImplementationsTreeNode implementationsNode : this.getMethodImplementations(new DirectionalTranslator(this.entryPool), methodEntry)) {
            this.getRelatedMethodImplementations(methodEntries, implementationsNode);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getRelatedMethodImplementations(methodEntries, (MethodInheritanceTreeNode)node.getChildAt(i));
        }
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodImplementationsTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (this.containsObfMethod(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedMethod = this.getBridgedMethod(methodEntry);
        while (bridgedMethod != null) {
            methodEntries.addAll(this.getRelatedMethodImplementations(bridgedMethod));
            bridgedMethod = this.getBridgedMethod(bridgedMethod);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getRelatedMethodImplementations(methodEntries, (MethodImplementationsTreeNode)node.getChildAt(i));
        }
    }

    public Collection<EntryReference<FieldEntry, MethodDefEntry>> getFieldReferences(FieldEntry fieldEntry) {
        return this.fieldReferences.get((Object)fieldEntry);
    }

    public Collection<FieldEntry> getReferencedFields(MethodDefEntry methodEntry) {
        HashSet fieldEntries = Sets.newHashSet();
        for (EntryReference reference : this.fieldReferences.values()) {
            if (reference.context != methodEntry) continue;
            fieldEntries.add(reference.entry);
        }
        return fieldEntries;
    }

    public Collection<EntryReference<MethodEntry, MethodDefEntry>> getMethodsReferencing(MethodEntry methodEntry) {
        return this.methodsReferencing.get((Object)methodEntry);
    }

    public Collection<MethodEntry> getReferencedMethods(MethodDefEntry methodEntry) {
        return this.methodReferences.get((Object)methodEntry);
    }

    public Collection<ClassEntry> getInnerClasses(ClassEntry obfOuterClassEntry) {
        return this.innerClassesByOuter.get((Object)obfOuterClassEntry);
    }

    public ClassEntry getOuterClass(ClassEntry obfInnerClassEntry) {
        return this.outerClassesByInner.get(obfInnerClassEntry);
    }

    public boolean isSyntheticMethod(MethodEntry methodEntry) {
        return this.syntheticMethods.contains(methodEntry);
    }

    public Set<ClassEntry> getInterfaces(String className) {
        ClassEntry classEntry = this.entryPool.getClass(className);
        HashSet<ClassEntry> interfaces = new HashSet<ClassEntry>(this.translationIndex.getInterfaces(classEntry));
        for (ClassEntry ancestor : this.translationIndex.getAncestry(classEntry)) {
            interfaces.addAll(this.translationIndex.getInterfaces(ancestor));
        }
        return interfaces;
    }

    public Set<String> getImplementingClasses(String targetInterfaceName) {
        HashSet classNames = Sets.newHashSet();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.translationIndex.getClassInterfaces()) {
            ClassEntry classEntry = entry.getKey();
            ClassEntry interfaceEntry = entry.getValue();
            if (!interfaceEntry.getName().equals(targetInterfaceName)) continue;
            String className = classEntry.getClassName();
            classNames.add(className);
            if (this.isInterface(className)) {
                classNames.addAll(this.getImplementingClasses(className));
            }
            this.translationIndex.getSubclassNamesRecursively(classNames, classEntry);
        }
        return classNames;
    }

    public boolean isInterface(String className) {
        return this.translationIndex.isInterface(this.entryPool.getClass(className));
    }

    public boolean containsObfClass(ClassEntry obfClassEntry) {
        return this.obfClassEntries.contains(obfClassEntry);
    }

    public boolean containsObfField(FieldEntry obfFieldEntry) {
        return this.access.containsKey(obfFieldEntry);
    }

    public boolean containsObfMethod(MethodEntry obfMethodEntry) {
        return this.access.containsKey(obfMethodEntry);
    }

    public boolean containsEntryWithSameName(Entry entry) {
        for (Entry target : this.access.keySet()) {
            if (!target.getName().equals(entry.getName()) || !entry.getClass().isInstance(target.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean containsObfVariable(LocalVariableEntry obfVariableEntry) {
        return this.containsObfMethod(obfVariableEntry.getOwnerEntry());
    }

    public boolean containsObfEntry(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            return this.containsObfClass((ClassEntry)obfEntry);
        }
        if (obfEntry instanceof FieldEntry) {
            return this.containsObfField((FieldEntry)obfEntry);
        }
        if (obfEntry instanceof MethodEntry) {
            return this.containsObfMethod((MethodEntry)obfEntry);
        }
        if (obfEntry instanceof LocalVariableEntry) {
            return this.containsObfVariable((LocalVariableEntry)obfEntry);
        }
        throw new Error("Entry desc not supported: " + obfEntry.getClass().getName());
    }

    public MethodEntry getBridgedMethod(MethodEntry bridgeMethodEntry) {
        return this.bridgedMethods.get(bridgeMethodEntry);
    }

    public List<ClassEntry> getObfClassChain(ClassEntry obfClassEntry) {
        ClassEntry obfOuterClassEntry;
        ArrayList obfClassChain = Lists.newArrayList((Object[])new ClassEntry[]{obfClassEntry});
        ClassEntry checkClassEntry = obfClassEntry;
        while ((obfOuterClassEntry = this.getOuterClass(checkClassEntry)) != null) {
            obfClassChain.add(obfOuterClassEntry);
            checkClassEntry = obfOuterClassEntry;
        }
        Collections.reverse(obfClassChain);
        return obfClassChain;
    }
}

