/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassImplementationsTreeNode
extends DefaultMutableTreeNode {
    private final Translator deobfuscatingTranslator;
    private final ClassEntry entry;

    public ClassImplementationsTreeNode(Translator deobfuscatingTranslator, ClassEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
    }

    public static ClassImplementationsTreeNode findNode(ClassImplementationsTreeNode node, MethodEntry entry) {
        if (node.entry.equals(entry.getOwnerClassEntry())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassImplementationsTreeNode foundNode = ClassImplementationsTreeNode.findNode((ClassImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public ClassEntry getClassEntry() {
        return this.entry;
    }

    public String getDeobfClassName() {
        return this.deobfuscatingTranslator.getTranslatedClass(this.entry).getClassName();
    }

    @Override
    public String toString() {
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.entry.getClassName();
        }
        return className;
    }

    public void load(JarIndex index) {
        ArrayList nodes = Lists.newArrayList();
        for (String implementingClassName : index.getImplementingClasses(this.entry.getClassName())) {
            nodes.add(new ClassImplementationsTreeNode(this.deobfuscatingTranslator, new ClassEntry(implementingClassName)));
        }
        nodes.forEach(this::add);
    }
}

