/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.MinecraftSyntaxKit;
import cuchaz.enigma.gui.highlight.DeobfuscatedHighlightPainter;
import cuchaz.enigma.gui.highlight.ObfuscatedHighlightPainter;
import cuchaz.enigma.gui.highlight.OtherHighlightPainter;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.Color;
import java.io.IOException;

public class Themes {
    public static void setDefault(Gui gui) {
        try {
            Config.getInstance().reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Themes.updateTheme(gui);
    }

    public static void setDark(Gui gui) {
        Config.getInstance().obfuscatedColor = 0xFF5555;
        Config.getInstance().obfuscatedHiglightAlpha = 0.3f;
        Config.getInstance().obfuscatedColorOutline = 0xFF5555;
        Config.getInstance().obfuscatedOutlineAlpha = 0.5f;
        Config.getInstance().deobfuscatedColor = 5307003;
        Config.getInstance().deobfuscatedHiglightAlpha = 0.3f;
        Config.getInstance().deobfuscatedColorOutline = 5307003;
        Config.getInstance().deobfuscatedOutlineAlpha = 0.5f;
        Config.getInstance().otherColorOutline = 0xB4B4B4;
        Config.getInstance().otherOutlineAlpha = 0.0f;
        Config.getInstance().editorBackground = 2632246;
        Config.getInstance().highlightColor = 16742854;
        Config.getInstance().stringColor = 15858316;
        Config.getInstance().numberColor = 12424185;
        Config.getInstance().operatorColor = 0xF8F8F2;
        Config.getInstance().delimiterColor = 0xF8F8F2;
        Config.getInstance().typeColor = 0xF8F8F2;
        Config.getInstance().identifierColor = 0xF8F8F2;
        Config.getInstance().defaultTextColor = 0xF8F8F2;
        Themes.updateTheme(gui);
    }

    public static void updateTheme(Gui gui) {
        try {
            Config.getInstance().saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MinecraftSyntaxKit.invalidate();
        DefaultSyntaxKit.initKit();
        DefaultSyntaxKit.registerContentType((String)"text/minecraft", (String)MinecraftSyntaxKit.class.getName());
        gui.obfuscatedHighlightPainter = new ObfuscatedHighlightPainter();
        gui.deobfuscatedHighlightPainter = new DeobfuscatedHighlightPainter();
        gui.otherHighlightPainter = new OtherHighlightPainter();
        gui.editor.updateUI();
        gui.editor.setBackground(new Color(Config.getInstance().editorBackground));
        gui.getController().refreshCurrentClass();
    }
}

