/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import java.util.HashMap;
import java.util.Map;

public class ReferencedEntryPool {
    private final Map<String, ClassEntry> classEntries = new HashMap<String, ClassEntry>();
    private final Map<String, Map<String, MethodEntry>> methodEntries = new HashMap<String, Map<String, MethodEntry>>();
    private final Map<String, Map<String, FieldEntry>> fieldEntries = new HashMap<String, Map<String, FieldEntry>>();

    public ClassEntry getClass(String name) {
        return this.classEntries.computeIfAbsent(name, s -> new ClassEntry(name));
    }

    public MethodEntry getMethod(ClassEntry ownerEntry, String name, String desc) {
        return this.getMethod(ownerEntry, name, new MethodDescriptor(desc));
    }

    public MethodEntry getMethod(ClassEntry ownerEntry, String name, MethodDescriptor desc) {
        String key = name + desc.toString();
        return this.getClassMethods(ownerEntry.getName()).computeIfAbsent(key, s -> new MethodEntry(ownerEntry, name, desc));
    }

    public FieldEntry getField(ClassEntry ownerEntry, String name, String desc) {
        return this.getField(ownerEntry, name, new TypeDescriptor(desc));
    }

    public FieldEntry getField(ClassEntry ownerEntry, String name, TypeDescriptor desc) {
        return this.getClassFields(ownerEntry.getName()).computeIfAbsent(name, s -> new FieldEntry(ownerEntry, name, desc));
    }

    private Map<String, MethodEntry> getClassMethods(String name) {
        return this.methodEntries.computeIfAbsent(name, s -> new HashMap());
    }

    private Map<String, FieldEntry> getClassFields(String name) {
        return this.fieldEntries.computeIfAbsent(name, s -> new HashMap());
    }
}

