/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassEntry;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassInheritanceTreeNode
extends DefaultMutableTreeNode {
    private final Translator deobfuscatingTranslator;
    private final ClassEntry obfClassEntry;

    public ClassInheritanceTreeNode(Translator deobfuscatingTranslator, String obfClassName) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.obfClassEntry = new ClassEntry(obfClassName);
    }

    public static ClassInheritanceTreeNode findNode(ClassInheritanceTreeNode node, ClassEntry entry) {
        if (node.getObfClassName().equals(entry.getName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassInheritanceTreeNode foundNode = ClassInheritanceTreeNode.findNode((ClassInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public String getObfClassName() {
        return this.obfClassEntry.getClassName();
    }

    public String getDeobfClassName() {
        return this.deobfuscatingTranslator.getTranslatedClass(this.obfClassEntry).getClassName();
    }

    @Override
    public String toString() {
        String deobfClassName = this.getDeobfClassName();
        if (deobfClassName != null) {
            return deobfClassName;
        }
        return this.obfClassEntry.getName();
    }

    public void load(TranslationIndex ancestries, boolean recurse) {
        ArrayList nodes = Lists.newArrayList();
        for (ClassEntry subclassEntry : ancestries.getSubclass(this.obfClassEntry)) {
            nodes.add(new ClassInheritanceTreeNode(this.deobfuscatingTranslator, subclassEntry.getName()));
        }
        nodes.forEach(this::add);
        if (recurse) {
            for (ClassInheritanceTreeNode node : nodes) {
                node.load(ancestries, true);
            }
        }
    }
}

