/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.bytecode.AccessFlags;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassProtectifier
extends ClassVisitor {
    public ClassProtectifier(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        access = ClassProtectifier.protectify(access);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        access = ClassProtectifier.protectify(access);
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        access = ClassProtectifier.protectify(access);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    private static int protectify(int access) {
        AccessFlags accessFlags = new AccessFlags(access);
        if (accessFlags.isPrivate()) {
            accessFlags.setProtected();
        }
        return accessFlags.getFlags();
    }
}

