/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableDefEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DirectionalTranslator
implements Translator {
    private final TranslationDirection direction;
    private final Map<String, ClassMapping> classes;
    private final TranslationIndex index;

    public DirectionalTranslator(ReferencedEntryPool entryPool) {
        this.direction = null;
        this.classes = Maps.newHashMap();
        this.index = new TranslationIndex(entryPool);
    }

    public DirectionalTranslator(TranslationDirection direction, Map<String, ClassMapping> classes, TranslationIndex index) {
        this.direction = direction;
        this.classes = classes;
        this.index = index;
    }

    public TranslationDirection getDirection() {
        return this.direction;
    }

    public TranslationIndex getTranslationIndex() {
        return this.index;
    }

    @Override
    public ClassEntry getTranslatedClass(ClassEntry entry) {
        String className = entry.isArray() ? this.getTranslatedTypeDesc(new TypeDescriptor(entry.getName())).toString() : (entry.isInnerClass() ? this.translateInnerClassName(entry) : this.translateClassName(entry));
        return new ClassEntry(className);
    }

    @Override
    public ClassDefEntry getTranslatedClassDef(ClassDefEntry entry) {
        String className = entry.isArray() ? this.getTranslatedTypeDesc(new TypeDescriptor(entry.getName())).toString() : (entry.isInnerClass() ? this.translateInnerClassName(entry) : this.translateClassName(entry));
        Signature translatedSignature = this.getTranslatedSignature(entry.getSignature());
        return new ClassDefEntry(className, translatedSignature, this.getClassModifier(entry).transform(entry.getAccess()));
    }

    private String translateClassName(ClassEntry entry) {
        ClassMapping classMapping = this.classes.get(entry.getName());
        if (classMapping == null) {
            return entry.getName();
        }
        return classMapping.getTranslatedName(this.direction);
    }

    private String translateInnerClassName(ClassEntry entry) {
        List<ClassMapping> mappingsChain = this.getClassMappingChain(entry);
        String[] obfClassNames = entry.getName().split("\\$");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < obfClassNames.length; ++i) {
            boolean isFirstClass = buf.length() == 0;
            String className = null;
            ClassMapping classMapping = mappingsChain.get(i);
            if (classMapping != null) {
                className = this.direction.choose(classMapping.getDeobfName(), isFirstClass ? classMapping.getObfFullName() : classMapping.getObfSimpleName());
            }
            if (className == null) {
                className = obfClassNames[i];
            }
            if (!isFirstClass) {
                buf.append("$");
            }
            buf.append(className);
        }
        return buf.toString();
    }

    @Override
    public FieldDefEntry getTranslatedFieldDef(FieldDefEntry entry) {
        String translatedName = this.translateFieldName(entry);
        if (translatedName == null) {
            translatedName = entry.getName();
        }
        ClassEntry translatedOwner = this.getTranslatedClass(entry.getOwnerClassEntry());
        TypeDescriptor translatedDesc = this.getTranslatedTypeDesc(entry.getDesc());
        Signature translatedSignature = this.getTranslatedSignature(entry.getSignature());
        AccessFlags translatedAccess = this.getFieldModifier(entry).transform(entry.getAccess());
        return new FieldDefEntry(translatedOwner, translatedName, translatedDesc, translatedSignature, translatedAccess);
    }

    @Override
    public FieldEntry getTranslatedField(FieldEntry entry) {
        String translatedName = this.translateFieldName(entry);
        if (translatedName == null) {
            translatedName = entry.getName();
        }
        ClassEntry translatedOwner = this.getTranslatedClass(entry.getOwnerClassEntry());
        TypeDescriptor translatedDesc = this.getTranslatedTypeDesc(entry.getDesc());
        return new FieldEntry(translatedOwner, translatedName, translatedDesc);
    }

    private String translateFieldName(FieldEntry entry) {
        FieldMapping mapping;
        ClassMapping classMapping;
        ClassEntry resolvedClassEntry = this.index.resolveEntryOwner(entry, true);
        if (resolvedClassEntry != null && (classMapping = this.findClassMapping(resolvedClassEntry)) != null && (mapping = this.direction.choose(classMapping.getFieldByObf(entry.getName(), entry.getDesc()), classMapping.getFieldByDeobf(entry.getName(), this.getTranslatedTypeDesc(entry.getDesc())))) != null) {
            return this.direction.choose(mapping.getDeobfName(), mapping.getObfName());
        }
        return null;
    }

    @Override
    public MethodDefEntry getTranslatedMethodDef(MethodDefEntry entry) {
        String translatedName = this.translateMethodName(entry);
        if (translatedName == null) {
            translatedName = entry.getName();
        }
        ClassEntry translatedOwner = this.getTranslatedClass(entry.getOwnerClassEntry());
        MethodDescriptor translatedDesc = this.getTranslatedMethodDesc(entry.getDesc());
        Signature translatedSignature = this.getTranslatedSignature(entry.getSignature());
        AccessFlags access = this.getMethodModifier(entry).transform(entry.getAccess());
        return new MethodDefEntry(translatedOwner, translatedName, translatedDesc, translatedSignature, access);
    }

    @Override
    public MethodEntry getTranslatedMethod(MethodEntry entry) {
        String translatedName = this.translateMethodName(entry);
        if (translatedName == null) {
            translatedName = entry.getName();
        }
        ClassEntry translatedOwner = this.getTranslatedClass(entry.getOwnerClassEntry());
        MethodDescriptor translatedDesc = this.getTranslatedMethodDesc(entry.getDesc());
        return new MethodEntry(translatedOwner, translatedName, translatedDesc);
    }

    private String translateMethodName(MethodEntry entry) {
        MethodMapping mapping;
        ClassMapping classMapping;
        ClassEntry resolvedOwner = this.index.resolveEntryOwner(entry, true);
        if (resolvedOwner != null && (classMapping = this.findClassMapping(resolvedOwner)) != null && (mapping = this.direction.choose(classMapping.getMethodByObf(entry.getName(), entry.getDesc()), classMapping.getMethodByDeobf(entry.getName(), this.getTranslatedMethodDesc(entry.getDesc())))) != null) {
            return this.direction.choose(mapping.getDeobfName(), mapping.getObfName());
        }
        return null;
    }

    @Override
    public LocalVariableEntry getTranslatedVariable(LocalVariableEntry entry) {
        String translatedArgumentName = this.translateLocalVariableName(entry);
        if (translatedArgumentName == null) {
            translatedArgumentName = this.inheritLocalVariableName(entry);
        }
        if (translatedArgumentName == null) {
            translatedArgumentName = entry.getName();
        }
        MethodEntry translatedOwner = this.getTranslatedMethod(entry.getOwnerEntry());
        return new LocalVariableEntry(translatedOwner, entry.getIndex(), translatedArgumentName, entry.isParameter());
    }

    @Override
    public LocalVariableDefEntry getTranslatedVariableDef(LocalVariableDefEntry entry) {
        String translatedArgumentName = this.translateLocalVariableName(entry);
        if (translatedArgumentName == null) {
            translatedArgumentName = this.inheritLocalVariableName(entry);
        }
        MethodDefEntry translatedOwner = this.getTranslatedMethodDef(entry.getOwnerEntry());
        TypeDescriptor translatedTypeDesc = this.getTranslatedTypeDesc(entry.getDesc());
        return new LocalVariableDefEntry(translatedOwner, entry.getIndex(), translatedArgumentName != null ? translatedArgumentName : entry.getName(), entry.isParameter(), translatedTypeDesc);
    }

    @Override
    public boolean hasClassMapping(ClassEntry entry) {
        return this.classes.containsKey(entry.getName());
    }

    @Override
    public boolean hasFieldMapping(FieldEntry entry) {
        return this.translateFieldName(entry) != null;
    }

    @Override
    public boolean hasMethodMapping(MethodEntry entry) {
        return this.translateMethodName(entry) != null;
    }

    @Override
    public boolean hasLocalVariableMapping(LocalVariableEntry entry) {
        return this.translateLocalVariableName(entry) != null || this.inheritLocalVariableName(entry) != null;
    }

    private String translateLocalVariableName(LocalVariableEntry entry) {
        MethodMapping methodMapping;
        ClassMapping classMapping;
        ClassEntry ownerEntry = entry.getOwnerClassEntry();
        if (ownerEntry != null && (classMapping = this.findClassMapping(ownerEntry)) != null && (methodMapping = this.direction.choose(classMapping.getMethodByObf(entry.getMethodName(), entry.getMethodDesc()), classMapping.getMethodByDeobf(entry.getMethodName(), this.getTranslatedMethodDesc(entry.getMethodDesc())))) != null) {
            int index = entry.getIndex();
            return this.direction.choose(methodMapping.getDeobfLocalVariableName(index), methodMapping.getObfLocalVariableName(index));
        }
        return null;
    }

    private String inheritLocalVariableName(LocalVariableEntry entry) {
        List<ClassEntry> ancestry = this.index.getAncestry(entry.getOwnerClassEntry());
        for (ClassEntry ancestorEntry : ancestry) {
            String result;
            LocalVariableEntry motherArg = entry.updateOwnership(ancestorEntry);
            if (!this.index.entryExists(motherArg) || (result = this.translateLocalVariableName(motherArg)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public TypeDescriptor getTranslatedTypeDesc(TypeDescriptor desc) {
        return desc.remap(this::remapClass);
    }

    @Override
    public MethodDescriptor getTranslatedMethodDesc(MethodDescriptor descriptor) {
        List<TypeDescriptor> arguments = descriptor.getArgumentDescs();
        ArrayList<TypeDescriptor> translatedArguments = new ArrayList<TypeDescriptor>(arguments.size());
        for (TypeDescriptor argument : arguments) {
            translatedArguments.add(this.getTranslatedTypeDesc(argument));
        }
        return new MethodDescriptor(translatedArguments, this.getTranslatedTypeDesc(descriptor.getReturnDesc()));
    }

    @Override
    public Signature getTranslatedSignature(Signature signature) {
        if (signature == null) {
            return null;
        }
        return signature.remap(this::remapClass);
    }

    private ClassMapping findClassMapping(ClassEntry entry) {
        List<ClassMapping> mappingChain = this.getClassMappingChain(entry);
        return mappingChain.get(mappingChain.size() - 1);
    }

    private List<ClassMapping> getClassMappingChain(ClassEntry entry) {
        String[] parts = entry.getName().split("\\$");
        ArrayList mappingsChain = Lists.newArrayList();
        ClassMapping outerClassMapping = this.classes.get(parts[0]);
        mappingsChain.add(outerClassMapping);
        for (int i = 1; i < parts.length; ++i) {
            ClassMapping innerClassMapping = null;
            if (outerClassMapping != null) {
                innerClassMapping = this.direction.choose(outerClassMapping.getInnerClassByObfSimple(parts[i]), outerClassMapping.getInnerClassByDeobfThenObfSimple(parts[i]));
            }
            mappingsChain.add(innerClassMapping);
            outerClassMapping = innerClassMapping;
        }
        assert (mappingsChain.size() == parts.length);
        return mappingsChain;
    }

    private Mappings.EntryModifier getClassModifier(ClassEntry entry) {
        ClassMapping classMapping = this.findClassMapping(entry);
        if (classMapping != null) {
            return classMapping.getModifier();
        }
        return Mappings.EntryModifier.UNCHANGED;
    }

    private Mappings.EntryModifier getFieldModifier(FieldEntry entry) {
        FieldMapping fieldMapping;
        ClassMapping classMapping = this.findClassMapping(entry.getOwnerClassEntry());
        if (classMapping != null && (fieldMapping = classMapping.getFieldByObf(entry)) != null) {
            return fieldMapping.getModifier();
        }
        return Mappings.EntryModifier.UNCHANGED;
    }

    private Mappings.EntryModifier getMethodModifier(MethodEntry entry) {
        MethodMapping methodMapping;
        ClassMapping classMapping = this.findClassMapping(entry.getOwnerClassEntry());
        if (classMapping != null && (methodMapping = classMapping.getMethodByObf(entry)) != null) {
            return methodMapping.getModifier();
        }
        return Mappings.EntryModifier.UNCHANGED;
    }

    private String remapClass(String name) {
        return this.getTranslatedClass(new ClassEntry(name)).getName();
    }
}

