/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.bytecode.translators.TranslationSignatureVisitor;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class Signature {
    private static final Pattern OBJECT_PATTERN = Pattern.compile(".*:Ljava/lang/Object;:.*");
    private final String signature;
    private final boolean isType;

    private Signature(String signature, boolean isType) {
        if (signature != null && OBJECT_PATTERN.matcher(signature).matches()) {
            signature = signature.replaceAll(":Ljava/lang/Object;:", "::");
        }
        this.signature = signature;
        this.isType = isType;
    }

    public static Signature createTypedSignature(String signature) {
        if (signature != null && !signature.isEmpty()) {
            return new Signature(signature, true);
        }
        return new Signature(null, true);
    }

    public static Signature createSignature(String signature) {
        if (signature != null && !signature.isEmpty()) {
            return new Signature(signature, false);
        }
        return new Signature(null, false);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isType() {
        return this.isType;
    }

    public Signature remap(Function<String, String> remapper) {
        if (this.signature == null) {
            return this;
        }
        SignatureWriter writer = new SignatureWriter();
        TranslationSignatureVisitor visitor = new TranslationSignatureVisitor(remapper, (SignatureVisitor)writer);
        if (this.isType) {
            new SignatureReader(this.signature).acceptType((SignatureVisitor)visitor);
        } else {
            new SignatureReader(this.signature).accept((SignatureVisitor)visitor);
        }
        return new Signature(writer.toString(), this.isType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Signature) {
            Signature other = (Signature)obj;
            return (other.signature == null && this.signature == null || other.signature != null && this.signature != null && other.signature.equals(this.signature)) && other.isType == this.isType;
        }
        return false;
    }

    public int hashCode() {
        return this.signature.hashCode() | (this.isType ? 1 : 0) << 16;
    }

    public String toString() {
        return this.signature;
    }
}

