/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import cuchaz.enigma.ITranslatingTypeLoader;
import cuchaz.enigma.SynchronizedTypeLoader;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.LocalVariableMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.mapping.MappingsRenamer;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import oml.ast.transformers.InvalidIdentifierFix;
import oml.ast.transformers.Java8Generics;
import oml.ast.transformers.ObfuscatedEnumSwitchRewriterTransform;
import oml.ast.transformers.RemoveObjectCasts;
import oml.ast.transformers.VarargsFixer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class Deobfuscator {
    private final ServiceLoader<EnigmaPlugin> plugins = ServiceLoader.load(EnigmaPlugin.class);
    private final ReferencedEntryPool entryPool = new ReferencedEntryPool();
    private final ParsedJar parsedJar;
    private final DecompilerSettings settings;
    private final JarIndex jarIndex;
    private final MappingsRenamer renamer;
    private final Map<TranslationDirection, Translator> translatorCache;
    private Mappings mappings;

    public Deobfuscator(ParsedJar jar, Consumer<String> listener) {
        this.parsedJar = jar;
        listener.accept("Indexing JAR...");
        this.jarIndex = new JarIndex(this.entryPool);
        this.jarIndex.indexJar(this.parsedJar, true);
        listener.accept("Initializing plugins...");
        for (EnigmaPlugin plugin : this.getPlugins()) {
            plugin.onClassesLoaded(this.parsedJar.getClassDataMap(), this.parsedJar::getClassNode);
        }
        listener.accept("Preparing...");
        this.settings = DecompilerSettings.javaDefaults();
        this.settings.setMergeVariables(Utils.getSystemPropertyAsBoolean("enigma.mergeVariables", true));
        this.settings.setForceExplicitImports(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitImports", true));
        this.settings.setForceExplicitTypeArguments(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitTypeArguments", true));
        this.settings.setShowDebugLineNumbers(Utils.getSystemPropertyAsBoolean("enigma.showDebugLineNumbers", false));
        this.settings.setShowSyntheticMembers(Utils.getSystemPropertyAsBoolean("enigma.showSyntheticMembers", false));
        this.translatorCache = Maps.newTreeMap();
        this.renamer = new MappingsRenamer(this.jarIndex, null, this.entryPool);
        this.setMappings(new Mappings());
    }

    public Deobfuscator(JarFile jar, Consumer<String> listener) throws IOException {
        this(new ParsedJar(jar), listener);
    }

    public Deobfuscator(ParsedJar jar) throws IOException {
        this(jar, (String msg) -> {});
    }

    public Deobfuscator(JarFile jar) throws IOException {
        this(jar, (String msg) -> {});
    }

    public ServiceLoader<EnigmaPlugin> getPlugins() {
        return this.plugins;
    }

    public ParsedJar getJar() {
        return this.parsedJar;
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings val) {
        this.setMappings(val, true);
    }

    public void setMappings(Mappings val, boolean warnAboutDrops) {
        if (val == null) {
            val = new Mappings();
        }
        MappingsChecker checker = new MappingsChecker(this.jarIndex);
        checker.dropBrokenMappings(val);
        if (warnAboutDrops) {
            for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedClassMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedInnerClassMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find inner class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedFieldMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find field entry " + entry.getKey() + " (" + ((FieldMapping)entry.getValue()).getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedMethodMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find behavior entry " + entry.getKey() + " (" + ((MethodMapping)entry.getValue()).getDeobfName() + ") in jar. Mapping was dropped.");
            }
        }
        this.mappings = val;
        this.renamer.setMappings(this.mappings);
        this.translatorCache.clear();
    }

    public Translator getTranslator(TranslationDirection direction) {
        return this.translatorCache.computeIfAbsent(direction, k -> this.mappings.getTranslator(direction, this.jarIndex.getTranslationIndex()));
    }

    public void getSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        for (ClassEntry obfClassEntry : this.jarIndex.getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            ClassEntry deobfClassEntry = this.deobfuscateEntry(obfClassEntry);
            if (!deobfClassEntry.equals(obfClassEntry)) {
                deobfClasses.add(deobfClassEntry);
                continue;
            }
            if (obfClassEntry.getPackageName() != null) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            obfClasses.add(obfClassEntry);
        }
    }

    public TranslatingTypeLoader createTypeLoader() {
        return new TranslatingTypeLoader(this.parsedJar, this.jarIndex, this.entryPool, this.getTranslator(TranslationDirection.OBFUSCATING), this.getTranslator(TranslationDirection.DEOBFUSCATING));
    }

    public CompilationUnit getSourceTree(String className) {
        return this.getSourceTree(className, this.createTypeLoader());
    }

    public CompilationUnit getSourceTree(String className, ITranslatingTypeLoader loader) {
        return this.getSourceTree(className, loader, new NoRetryMetadataSystem(loader));
    }

    public CompilationUnit getSourceTree(String className, ITranslatingTypeLoader loader, MetadataSystem metadataSystem) {
        String deobfClassName = className;
        ClassMapping classMapping = this.mappings.getClassByObf(className);
        if (classMapping != null && classMapping.getDeobfName() != null) {
            deobfClassName = classMapping.getDeobfName();
        }
        this.settings.setTypeLoader((ITypeLoader)loader);
        TypeReference type = metadataSystem.lookupType(deobfClassName);
        if (type == null) {
            throw new Error(String.format("Unable to find desc: %s (deobf: %s)\nTried class names: %s", className, deobfClassName, loader.getClassNamesToTry(deobfClassName)));
        }
        TypeDefinition resolvedType = type.resolve();
        DecompilerContext context = new DecompilerContext();
        context.setCurrentType(resolvedType);
        context.setSettings(this.settings);
        AstBuilder builder = new AstBuilder(context);
        builder.addType(resolvedType);
        builder.runTransformations(null);
        Deobfuscator.runCustomTransforms(builder, context);
        return builder.getCompilationUnit();
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source) {
        return this.getSourceIndex(sourceTree, source, null);
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source, Boolean ignoreBadTokens) {
        SourceIndex index = ignoreBadTokens != null ? new SourceIndex(source, ignoreBadTokens) : new SourceIndex(source);
        sourceTree.acceptVisitor((IAstVisitor)new SourceIndexVisitor(this.entryPool), (Object)index);
        for (Token token : index.referenceTokens()) {
            EntryReference<Entry, Entry> deobfReference = index.getDeobfReference(token);
            Object obfEntry = this.obfuscateEntry((Entry)deobfReference.entry);
            ClassEntry resolvedObfClassEntry = this.jarIndex.getTranslationIndex().resolveEntryOwner((Entry)obfEntry);
            if (resolvedObfClassEntry == null || resolvedObfClassEntry.equals(obfEntry.getOwnerClassEntry())) continue;
            obfEntry = obfEntry.updateOwnership(resolvedObfClassEntry);
            deobfReference.entry = this.deobfuscateEntry((Entry)obfEntry);
            index.replaceDeobfReference(token, deobfReference);
        }
        return index;
    }

    public String getSource(CompilationUnit sourceTree) {
        StringWriter buf = new StringWriter();
        sourceTree.acceptVisitor((IAstVisitor)new InsertParenthesesVisitor(), null);
        sourceTree.acceptVisitor((IAstVisitor)new JavaOutputVisitor((ITextOutput)new PlainTextOutput((Writer)buf), this.settings), null);
        return buf.toString();
    }

    public void writeSources(File dirOut, ProgressListener progress) {
        HashSet classEntries = Sets.newHashSet();
        for (ClassEntry obfClassEntry2 : this.jarIndex.getObfClassEntries()) {
            if (obfClassEntry2.isInnerClass()) continue;
            classEntries.add(obfClassEntry2);
        }
        if (progress != null) {
            progress.init(classEntries.size(), "Decompiling classes...");
        }
        SynchronizedTypeLoader typeLoader = new SynchronizedTypeLoader(this.createTypeLoader());
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(typeLoader);
        metadataSystem.setEagerMethodLoadingEnabled(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        AtomicInteger count = new AtomicInteger();
        classEntries.parallelStream().forEach(obfClassEntry -> {
            ClassEntry deobfClassEntry = this.deobfuscateEntry(new ClassEntry((ClassEntry)obfClassEntry));
            if (progress != null) {
                progress.onProgress(count.getAndIncrement(), deobfClassEntry.toString());
            }
            try {
                CompilationUnit sourceTree = this.getSourceTree(obfClassEntry.getName(), typeLoader, metadataSystem);
                File file = new File(dirOut, deobfClassEntry.getName().replace('.', '/') + ".java");
                file.getParentFile().mkdirs();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    sourceTree.acceptVisitor((IAstVisitor)new InsertParenthesesVisitor(), null);
                    sourceTree.acceptVisitor((IAstVisitor)new JavaOutputVisitor((ITextOutput)new PlainTextOutput((Writer)writer), this.settings), null);
                }
            }
            catch (Throwable t) {
                System.err.println("Unable to deobfuscate class " + deobfClassEntry + " (" + obfClassEntry + ")");
                t.printStackTrace(System.err);
            }
        });
        stopwatch.stop();
        System.out.println("writeSources Done in : " + stopwatch.toString());
        if (progress != null) {
            progress.onProgress(count.get(), "Done:");
        }
    }

    private void addAllPotentialAncestors(Set<ClassEntry> classEntries, ClassEntry classObfEntry) {
        for (ClassEntry interfaceEntry : this.jarIndex.getTranslationIndex().getInterfaces(classObfEntry)) {
            if (!classEntries.add(interfaceEntry)) continue;
            this.addAllPotentialAncestors(classEntries, interfaceEntry);
        }
        ClassEntry superClassEntry = this.jarIndex.getTranslationIndex().getSuperclass(classObfEntry);
        if (superClassEntry != null && classEntries.add(superClassEntry)) {
            this.addAllPotentialAncestors(classEntries, superClassEntry);
        }
    }

    public boolean isMethodProvider(MethodEntry methodEntry) {
        HashSet<ClassEntry> classEntries = new HashSet<ClassEntry>();
        this.addAllPotentialAncestors(classEntries, methodEntry.getOwnerClassEntry());
        for (ClassEntry parentEntry : classEntries) {
            MethodEntry ancestorMethodEntry = this.entryPool.getMethod(parentEntry, methodEntry.getName(), methodEntry.getDesc());
            if (!this.jarIndex.containsObfMethod(ancestorMethodEntry)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isMethodProvider(ClassEntry classObfEntry, MethodEntry methodEntry) {
        HashSet<ClassEntry> classEntries = new HashSet<ClassEntry>();
        this.addAllPotentialAncestors(classEntries, classObfEntry);
        for (ClassEntry parentEntry : classEntries) {
            MethodEntry ancestorMethodEntry = this.entryPool.getMethod(parentEntry, methodEntry.getName(), methodEntry.getDesc());
            if (!this.jarIndex.containsObfMethod(ancestorMethodEntry)) continue;
            return false;
        }
        return true;
    }

    public void rebuildMethodNames(ProgressListener progress) {
        AtomicInteger i = new AtomicInteger();
        ConcurrentHashMap renameClassMap = new ConcurrentHashMap();
        progress.init(this.getMappings().classes().size() * 3, "Rebuilding method names");
        Lists.newArrayList(this.getMappings().classes()).parallelStream().forEach(classMapping -> {
            progress.onProgress(i.getAndIncrement(), classMapping.getDeobfName());
            this.rebuildMethodNames((ClassMapping)classMapping, renameClassMap);
        });
        renameClassMap.entrySet().stream().forEach(renameClassMapEntry -> {
            progress.onProgress(i.getAndIncrement(), ((ClassMapping)renameClassMapEntry.getKey()).getDeobfName());
            for (Map.Entry entry : ((Map)renameClassMapEntry.getValue()).entrySet()) {
                Entry obfEntry = (Entry)entry.getKey();
                this.removeMapping(obfEntry, false);
            }
        });
        this.translatorCache.clear();
        renameClassMap.entrySet().stream().forEach(renameClassMapEntry -> {
            progress.onProgress(i.getAndIncrement(), ((ClassMapping)renameClassMapEntry.getKey()).getDeobfName());
            for (Map.Entry entry : ((Map)renameClassMapEntry.getValue()).entrySet()) {
                Entry obfEntry = (Entry)entry.getKey();
                String name = (String)entry.getValue();
                if (name == null) continue;
                try {
                    this.rename(obfEntry, name);
                }
                catch (IllegalNameException exception) {
                    System.out.println("WARNING: " + exception.getMessage());
                }
            }
        });
    }

    private void rebuildMethodNames(ClassMapping classMapping, Map<ClassMapping, Map<Entry, String>> renameClassMap) {
        HashMap<Entry, String> renameEntries = new HashMap<Entry, String>();
        for (MethodMapping methodMapping : Lists.newArrayList(classMapping.methods())) {
            ClassEntry classObfEntry = classMapping.getObfEntry();
            MethodEntry obfEntry = methodMapping.getObfEntry(classObfEntry);
            boolean isProvider = this.isMethodProvider(obfEntry);
            if (this.hasDeobfuscatedName(obfEntry) && !methodMapping.getDeobfName().equals(methodMapping.getObfName())) {
                renameEntries.put(obfEntry, isProvider ? methodMapping.getDeobfName() : null);
            }
            if (!isProvider) continue;
            for (LocalVariableMapping localVariableMapping : methodMapping.arguments()) {
                LocalVariableEntry argObfEntry = localVariableMapping.getObfEntry(obfEntry);
                if (!this.hasDeobfuscatedName(argObfEntry)) continue;
                renameEntries.put(argObfEntry, this.deobfuscateEntry(argObfEntry).getName());
            }
        }
        classMapping.markDirty();
        renameClassMap.put(classMapping, renameEntries);
        for (ClassMapping innerClass : classMapping.innerClasses()) {
            this.rebuildMethodNames(innerClass, renameClassMap);
        }
    }

    public void writeJar(File out, ProgressListener progress) {
        this.transformJar(out, progress, this.createTypeLoader()::transformInto);
    }

    public void transformJar(File out, ProgressListener progress, ClassTransformer transformer) {
        try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
            if (progress != null) {
                progress.init(this.parsedJar.getClassCount(), "Transforming classes...");
            }
            AtomicInteger i = new AtomicInteger();
            this.parsedJar.visitNode(node -> {
                if (progress != null) {
                    progress.onProgress(i.getAndIncrement(), node.name);
                }
                try {
                    ClassWriter writer = new ClassWriter(0);
                    String transformedName = transformer.transform((ClassNode)node, writer);
                    outJar.putNextEntry(new JarEntry(transformedName.replace('.', '/') + ".class"));
                    outJar.write(writer.toByteArray());
                    outJar.closeEntry();
                }
                catch (Throwable t) {
                    throw new Error("Unable to transform class " + node.name, t);
                }
            });
            if (progress != null) {
                progress.onProgress(i.get(), "Done!");
            }
        }
        catch (IOException ex) {
            throw new Error("Unable to write to Jar file!");
        }
    }

    public <T extends Entry> T obfuscateEntry(T deobfEntry) {
        if (deobfEntry == null) {
            return null;
        }
        T translatedEntry = this.getTranslator(TranslationDirection.OBFUSCATING).getTranslatedEntry(deobfEntry);
        if (translatedEntry == null) {
            return deobfEntry;
        }
        return translatedEntry;
    }

    public <T extends Entry> T deobfuscateEntry(T obfEntry) {
        if (obfEntry == null) {
            return null;
        }
        T translatedEntry = this.getTranslator(TranslationDirection.DEOBFUSCATING).getTranslatedEntry(obfEntry);
        if (translatedEntry == null) {
            return obfEntry;
        }
        return translatedEntry;
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> obfuscateReference(EntryReference<E, C> deobfReference) {
        if (deobfReference == null) {
            return null;
        }
        return new EntryReference(this.obfuscateEntry((Entry)deobfReference.entry), this.obfuscateEntry((Entry)deobfReference.context), deobfReference);
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> deobfuscateReference(EntryReference<E, C> obfReference) {
        if (obfReference == null) {
            return null;
        }
        return new EntryReference(this.deobfuscateEntry((Entry)obfReference.entry), this.deobfuscateEntry((Entry)obfReference.context), obfReference);
    }

    public boolean isObfuscatedIdentifier(Entry obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        }
        return this.jarIndex.containsObfEntry(obfEntry);
    }

    public boolean isRenameable(EntryReference<Entry, Entry> obfReference) {
        return obfReference.isNamed() && this.isObfuscatedIdentifier(obfReference.getNameableEntry());
    }

    public boolean hasDeobfuscatedName(Entry obfEntry) {
        Translator translator = this.getTranslator(TranslationDirection.DEOBFUSCATING);
        if (obfEntry instanceof ClassEntry) {
            ClassEntry obfClass = (ClassEntry)obfEntry;
            List<ClassMapping> mappingChain = this.mappings.getClassMappingChain(obfClass);
            ClassMapping classMapping = mappingChain.get(mappingChain.size() - 1);
            return classMapping != null && classMapping.getDeobfName() != null;
        }
        if (obfEntry instanceof FieldEntry) {
            return translator.hasFieldMapping((FieldEntry)obfEntry);
        }
        if (obfEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)obfEntry;
            if (methodEntry.isConstructor()) {
                return false;
            }
            return translator.hasMethodMapping(methodEntry);
        }
        if (obfEntry instanceof LocalVariableEntry) {
            return translator.hasLocalVariableMapping((LocalVariableEntry)obfEntry);
        }
        throw new Error("Unknown entry desc: " + obfEntry.getClass().getName());
    }

    public void rename(Entry obfEntry, String newName) {
        this.rename(obfEntry, newName, true);
    }

    public void rename(Entry obfEntry, String newName, boolean clearCache) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.setClassName((ClassEntry)obfEntry, newName);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.setFieldName((FieldEntry)obfEntry, newName);
        } else if (obfEntry instanceof MethodEntry) {
            if (((MethodEntry)obfEntry).isConstructor()) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            this.renamer.setMethodTreeName((MethodEntry)obfEntry, newName);
        } else if (obfEntry instanceof LocalVariableEntry) {
            this.renamer.setLocalVariableTreeName((LocalVariableEntry)obfEntry, newName);
        } else {
            throw new Error("Unknown entry desc: " + obfEntry.getClass().getName());
        }
        if (clearCache) {
            this.translatorCache.clear();
        }
    }

    public void removeMapping(Entry obfEntry) {
        this.removeMapping(obfEntry, true);
    }

    public void removeMapping(Entry obfEntry, boolean clearCache) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.removeClassMapping((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.removeFieldMapping((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            if (((MethodEntry)obfEntry).isConstructor()) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            this.renamer.removeMethodTreeMapping((MethodEntry)obfEntry);
        } else if (obfEntry instanceof LocalVariableEntry) {
            this.renamer.removeLocalVariableMapping((LocalVariableEntry)obfEntry);
        } else {
            throw new Error("Unknown entry desc: " + obfEntry);
        }
        if (clearCache) {
            this.translatorCache.clear();
        }
    }

    public void markAsDeobfuscated(Entry obfEntry) {
        this.markAsDeobfuscated(obfEntry, true);
    }

    public void markAsDeobfuscated(Entry obfEntry, boolean clearCache) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.markClassAsDeobfuscated((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.markFieldAsDeobfuscated((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)obfEntry;
            if (methodEntry.isConstructor()) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            this.renamer.markMethodTreeAsDeobfuscated(methodEntry);
        } else if (obfEntry instanceof LocalVariableEntry) {
            this.renamer.markArgumentAsDeobfuscated((LocalVariableEntry)obfEntry);
        } else {
            throw new Error("Unknown entry desc: " + obfEntry);
        }
        if (clearCache) {
            this.translatorCache.clear();
        }
    }

    public void changeModifier(Entry entry, Mappings.EntryModifier modifierEntry) {
        Entry obfEntry = this.obfuscateEntry(entry);
        if (obfEntry instanceof ClassEntry) {
            this.renamer.setClassModifier((ClassEntry)obfEntry, modifierEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.setFieldModifier((FieldEntry)obfEntry, modifierEntry);
        } else if (obfEntry instanceof MethodEntry) {
            this.renamer.setMethodModifier((MethodEntry)obfEntry, modifierEntry);
        } else {
            throw new Error("Unknown entry desc: " + obfEntry);
        }
    }

    public Mappings.EntryModifier getModifier(Entry obfEntry) {
        Entry entry = this.obfuscateEntry(obfEntry);
        if (entry != null) {
            obfEntry = entry;
        }
        if (obfEntry instanceof ClassEntry) {
            return this.renamer.getClassModifier((ClassEntry)obfEntry);
        }
        if (obfEntry instanceof FieldEntry) {
            return this.renamer.getFieldModifier((FieldEntry)obfEntry);
        }
        if (obfEntry instanceof MethodEntry) {
            return this.renamer.getMethodModfifier((MethodEntry)obfEntry);
        }
        throw new Error("Unknown entry desc: " + obfEntry);
    }

    public static void runCustomTransforms(AstBuilder builder, DecompilerContext context) {
        List<IAstTransform> transformers = Arrays.asList(new ObfuscatedEnumSwitchRewriterTransform(context), new VarargsFixer(context), new RemoveObjectCasts(context), new Java8Generics(), new InvalidIdentifierFix());
        for (IAstTransform transform : transformers) {
            transform.run((AstNode)builder.getCompilationUnit());
        }
    }

    public static class NoRetryMetadataSystem
    extends MetadataSystem {
        private final Set<String> _failedTypes = Collections.newSetFromMap(new ConcurrentHashMap());

        public NoRetryMetadataSystem(ITypeLoader typeLoader) {
            super(typeLoader);
        }

        protected synchronized TypeDefinition resolveType(String descriptor, boolean mightBePrimitive) {
            if (this._failedTypes.contains(descriptor)) {
                return null;
            }
            TypeDefinition result = super.resolveType(descriptor, mightBePrimitive);
            if (result == null) {
                this._failedTypes.add(descriptor);
            }
            return result;
        }

        public synchronized TypeDefinition resolve(TypeReference type) {
            return super.resolve(type);
        }
    }

    public static interface ClassTransformer {
        public String transform(ClassNode var1, ClassWriter var2);
    }

    public static interface ProgressListener {
        public void init(int var1, String var2);

        public void onProgress(int var1, String var2);
    }
}

