/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public class IndexReferenceVisitor
extends ClassVisitor {
    private final JarIndex index;
    private ClassEntry classEntry;

    public IndexReferenceVisitor(JarIndex index, int api) {
        super(api);
        this.index = index;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classEntry = new ClassEntry(name);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDefEntry entry = new MethodDefEntry(this.classEntry, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        return new Method(this.index, entry, this.api);
    }

    private class Method
    extends MethodVisitor {
        private final JarIndex index;
        private final MethodDefEntry callerEntry;

        public Method(JarIndex index, MethodDefEntry callerEntry, int api) {
            super(api);
            this.index = index;
            this.callerEntry = callerEntry;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.index.indexFieldAccess(this.callerEntry, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.index.indexMethodCall(this.callerEntry, owner, name, desc);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            block4: for (Object bsmArg : bsmArgs) {
                if (!(bsmArg instanceof Handle)) continue;
                Handle handle = (Handle)bsmArg;
                switch (handle.getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.index.indexFieldAccess(this.callerEntry, handle.getOwner(), handle.getName(), handle.getDesc());
                        continue block4;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.index.indexMethodCall(this.callerEntry, handle.getOwner(), handle.getName(), handle.getDesc());
                    }
                }
            }
        }
    }
}

