/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.bytecode.translators.TranslationAnnotationVisitor;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableDefEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class TranslationMethodVisitor
extends MethodVisitor {
    private final ClassDefEntry ownerEntry;
    private final MethodDefEntry methodEntry;
    private final Translator translator;
    private boolean hasParameterMeta;

    public TranslationMethodVisitor(Translator translator, ClassDefEntry ownerEntry, MethodDefEntry methodEntry, int api, MethodVisitor mv) {
        super(api, mv);
        this.translator = translator;
        this.ownerEntry = ownerEntry;
        this.methodEntry = methodEntry;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        FieldEntry entry = new FieldEntry(new ClassEntry(owner), name, new TypeDescriptor(desc));
        FieldEntry translatedEntry = this.translator.getTranslatedField(entry);
        super.visitFieldInsn(opcode, translatedEntry.getClassName(), translatedEntry.getName(), translatedEntry.getDesc().toString());
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MethodEntry entry = new MethodEntry(new ClassEntry(owner), name, new MethodDescriptor(desc));
        MethodEntry translatedEntry = this.translator.getTranslatedMethod(entry);
        super.visitMethodInsn(opcode, translatedEntry.getClassName(), translatedEntry.getName(), translatedEntry.getDesc().toString(), itf);
    }

    public void visitFrame(int type, int localCount, Object[] locals, int stackCount, Object[] stack) {
        Object[] translatedLocals = this.getTranslatedFrame(locals, localCount);
        Object[] translatedStack = this.getTranslatedFrame(stack, stackCount);
        super.visitFrame(type, localCount, translatedLocals, stackCount, translatedStack);
    }

    private Object[] getTranslatedFrame(Object[] array, int count) {
        if (array == null) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            Object object = array[i];
            if (!(object instanceof String)) continue;
            String type = (String)object;
            array[i] = this.translator.getTranslatedClass(new ClassEntry(type)).getName();
        }
        return array;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        TypeDescriptor typeDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
        AnnotationVisitor av = super.visitAnnotation(typeDesc.toString(), visible);
        return new TranslationAnnotationVisitor(this.translator, typeDesc.getTypeEntry(), this.api, av);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        TypeDescriptor typeDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
        AnnotationVisitor av = super.visitParameterAnnotation(parameter, typeDesc.toString(), visible);
        return new TranslationAnnotationVisitor(this.translator, typeDesc.getTypeEntry(), this.api, av);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeDescriptor typeDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
        AnnotationVisitor av = super.visitTypeAnnotation(typeRef, typePath, typeDesc.toString(), visible);
        return new TranslationAnnotationVisitor(this.translator, typeDesc.getTypeEntry(), this.api, av);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.hasParameterMeta = true;
        String translatedSignature = this.translator.getTranslatedSignature(Signature.createTypedSignature(signature)).toString();
        int argumentIndex = this.methodEntry.getArgumentIndex(this.ownerEntry, index);
        if (argumentIndex >= 0) {
            LocalVariableDefEntry entry = new LocalVariableDefEntry(this.methodEntry, index, name, new TypeDescriptor(desc));
            LocalVariableDefEntry translatedEntry = this.translator.getTranslatedVariableDef(entry);
            String translatedName = translatedEntry.getName();
            if (translatedName.equals(entry.getName())) {
                List<TypeDescriptor> arguments = this.methodEntry.getDesc().getArgumentDescs();
                List<TypeDescriptor> translatedArguments = arguments.stream().map(this.translator::getTranslatedTypeDesc).collect(Collectors.toList());
                boolean argument = argumentIndex < arguments.size();
                translatedName = argument ? this.inferArgumentName(argumentIndex, translatedEntry.getDesc(), translatedArguments) : this.inferLocalVariableName(argumentIndex, translatedEntry.getDesc());
            }
            super.visitLocalVariable(translatedName, translatedEntry.getDesc().toString(), translatedSignature, start, end, index);
        } else {
            TypeDescriptor translatedDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
            super.visitLocalVariable(name, translatedDesc.toString(), translatedSignature, start, end, index);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        ClassEntry translatedEntry = this.translator.getTranslatedClass(new ClassEntry(type));
        super.visitTypeInsn(opcode, translatedEntry.getName());
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        MethodDescriptor translatedMethodDesc = this.translator.getTranslatedMethodDesc(new MethodDescriptor(desc));
        Object[] translatedBsmArgs = new Object[bsmArgs.length];
        for (int i = 0; i < bsmArgs.length; ++i) {
            translatedBsmArgs[i] = this.translator.getTranslatedValue(bsmArgs[i]);
        }
        super.visitInvokeDynamicInsn(name, translatedMethodDesc.toString(), this.translator.getTranslatedHandle(bsm), translatedBsmArgs);
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(this.translator.getTranslatedValue(cst));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc)).toString(), dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            ClassEntry translatedEntry = this.translator.getTranslatedClass(new ClassEntry(type));
            super.visitTryCatchBlock(start, end, handler, translatedEntry.getName());
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitEnd() {
        if (!this.hasParameterMeta) {
            List<TypeDescriptor> arguments = this.methodEntry.getDesc().getArgumentDescs();
            int offset = (this.methodEntry.getAccess().getFlags() & 0x400) != 0 ? 1 : 0;
            for (int argumentIndex = 0; argumentIndex < arguments.size(); ++argumentIndex) {
                LocalVariableEntry entry = new LocalVariableEntry(this.methodEntry, offset, "", true);
                LocalVariableEntry translatedEntry = this.translator.getTranslatedVariable(entry);
                String translatedName = translatedEntry.getName();
                if (translatedName.equals(entry.getName())) {
                    super.visitParameter(this.inferArgumentName(argumentIndex, arguments.get(argumentIndex), arguments), 0);
                } else {
                    super.visitParameter(translatedName, 0);
                }
                offset += arguments.get(argumentIndex).getSize();
            }
        }
        super.visitEnd();
    }

    private String inferArgumentName(int index, TypeDescriptor desc, Collection<TypeDescriptor> arguments) {
        boolean uniqueType = arguments.stream().filter(desc::equals).count() <= 1L;
        int nameIndex = index + 1;
        StringBuilder nameBuilder = new StringBuilder(this.getTypeName(desc));
        if (!uniqueType || NameValidator.isReserved(nameBuilder.toString())) {
            nameBuilder.append(nameIndex);
        }
        String translatedName = nameBuilder.toString();
        return translatedName;
    }

    private String inferLocalVariableName(int index, TypeDescriptor desc) {
        int nameIndex = index + 1;
        return this.getTypeName(desc) + nameIndex;
    }

    private String getTypeName(TypeDescriptor desc) {
        if (desc.isPrimitive()) {
            TypeDescriptor.Primitive argCls = desc.getPrimitive();
            return argCls.name().toLowerCase(Locale.ROOT);
        }
        if (desc.isArray()) {
            return "arr";
        }
        if (desc.isType()) {
            String typeName = desc.getTypeEntry().getSimpleName().replace("$", "");
            typeName = typeName.substring(0, 1).toLowerCase(Locale.ROOT) + typeName.substring(1);
            return typeName;
        }
        System.err.println("Encountered invalid argument type descriptor " + desc.toString());
        return "var";
    }
}

