/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import com.google.common.io.CharStreams;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

public class Utils {
    public static int combineHashesOrdered(Object ... objs) {
        int prime = 67;
        int result = 1;
        for (Object obj : objs) {
            result *= 67;
            if (obj == null) continue;
            result += obj.hashCode();
        }
        return result;
    }

    public static int combineHashesOrdered(List<Object> objs) {
        int prime = 67;
        int result = 1;
        for (Object obj : objs) {
            result *= 67;
            if (obj == null) continue;
            result += obj.hashCode();
        }
        return result;
    }

    public static String readStreamToString(InputStream in) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(in, "UTF-8"));
    }

    public static String readResourceToString(String path) throws IOException {
        InputStream in = Utils.class.getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException("Resource not found! " + path);
        }
        return Utils.readStreamToString(in);
    }

    public static void openUrl(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public static JLabel unboldLabel(JLabel label) {
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
        return label;
    }

    public static void showToolTipNow(JComponent component) {
        ToolTipManager manager = ToolTipManager.sharedInstance();
        int oldDelay = manager.getInitialDelay();
        manager.setInitialDelay(0);
        manager.mouseMoved(new MouseEvent(component, 503, System.currentTimeMillis(), 0, 0, 0, 0, false));
        manager.setInitialDelay(oldDelay);
    }

    public static boolean getSystemPropertyAsBoolean(String property, boolean defValue) {
        String value = System.getProperty(property);
        return value == null ? defValue : Boolean.parseBoolean(value);
    }
}

