/*
 * Decompiled with CFR 0.152.
 */
package oml.ast.transformers;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.SafeCloseable;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObfuscatedEnumSwitchRewriterTransform
implements IAstTransform {
    private final DecompilerContext _context;

    public ObfuscatedEnumSwitchRewriterTransform(DecompilerContext context) {
        this._context = (DecompilerContext)VerifyArgument.notNull((Object)context, (String)"context");
    }

    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor((IAstVisitor)new Visitor(this._context), null);
    }

    private static final class Visitor
    extends ContextTrackingVisitor<Void> {
        private final Map<String, SwitchMapInfo> _switchMaps = new LinkedHashMap<String, SwitchMapInfo>();
        private boolean _isSwitchMapWrapper;

        protected Visitor(DecompilerContext context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
            boolean oldIsSwitchMapWrapper = this._isSwitchMapWrapper;
            TypeDefinition typeDefinition = (TypeDefinition)typeDeclaration.getUserData(Keys.TYPE_DEFINITION);
            boolean isSwitchMapWrapper = Visitor.isSwitchMapWrapper((TypeReference)typeDefinition);
            if (isSwitchMapWrapper) {
                String internalName = typeDefinition.getInternalName();
                SwitchMapInfo info = this._switchMaps.get(internalName);
                if (info == null) {
                    info = new SwitchMapInfo(internalName);
                    this._switchMaps.put(internalName, info);
                }
                info.enclosingTypeDeclaration = typeDeclaration;
            }
            this._isSwitchMapWrapper = isSwitchMapWrapper;
            try {
                super.visitTypeDeclaration(typeDeclaration, p);
            }
            finally {
                this._isSwitchMapWrapper = oldIsSwitchMapWrapper;
            }
            this.rewrite();
            return null;
        }

        public Void visitSwitchStatement(SwitchStatement node, Void data) {
            Expression test = node.getExpression();
            if (test instanceof IndexerExpression) {
                List<SwitchStatement> switches;
                IndexerExpression indexer = (IndexerExpression)test;
                Expression array = indexer.getTarget();
                Expression argument = indexer.getArgument();
                if (!(array instanceof MemberReferenceExpression)) {
                    return (Void)super.visitSwitchStatement(node, (Object)data);
                }
                MemberReferenceExpression arrayAccess = (MemberReferenceExpression)array;
                Expression arrayOwner = arrayAccess.getTarget();
                String mapName = arrayAccess.getMemberName();
                if (mapName == null || mapName.startsWith("$SwitchMap$") || !(arrayOwner instanceof TypeReferenceExpression)) {
                    return (Void)super.visitSwitchStatement(node, (Object)data);
                }
                TypeReferenceExpression enclosingTypeExpression = (TypeReferenceExpression)arrayOwner;
                TypeReference enclosingType = (TypeReference)enclosingTypeExpression.getType().getUserData(Keys.TYPE_REFERENCE);
                if (!Visitor.isSwitchMapWrapper(enclosingType) || !(argument instanceof InvocationExpression)) {
                    return (Void)super.visitSwitchStatement(node, (Object)data);
                }
                InvocationExpression invocation = (InvocationExpression)argument;
                Expression invocationTarget = invocation.getTarget();
                if (!(invocationTarget instanceof MemberReferenceExpression)) {
                    return (Void)super.visitSwitchStatement(node, (Object)data);
                }
                MemberReferenceExpression memberReference = (MemberReferenceExpression)invocationTarget;
                if (!"ordinal".equals(memberReference.getMemberName())) {
                    return (Void)super.visitSwitchStatement(node, (Object)data);
                }
                String enclosingTypeName = enclosingType.getInternalName();
                SwitchMapInfo info = this._switchMaps.get(enclosingTypeName);
                if (info == null) {
                    info = new SwitchMapInfo(enclosingTypeName);
                    this._switchMaps.put(enclosingTypeName, info);
                    TypeDefinition resolvedType = enclosingType.resolve();
                    if (resolvedType != null) {
                        AstBuilder astBuilder = (AstBuilder)this.context.getUserData(Keys.AST_BUILDER);
                        if (astBuilder == null) {
                            astBuilder = new AstBuilder(this.context);
                        }
                        try (SafeCloseable importSuppression = astBuilder.suppressImports();){
                            TypeDeclaration declaration = astBuilder.createType(resolvedType);
                            declaration.acceptVisitor((IAstVisitor)this, (Object)data);
                        }
                    }
                }
                if ((switches = info.switches.get(mapName)) == null) {
                    switches = new ArrayList<SwitchStatement>();
                    info.switches.put(mapName, switches);
                }
                switches.add(node);
            }
            return (Void)super.visitSwitchStatement(node, (Object)data);
        }

        public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
            TypeDefinition currentType = this.context.getCurrentType();
            MethodDefinition currentMethod = this.context.getCurrentMethod();
            if (this._isSwitchMapWrapper && currentType != null && currentMethod != null && currentMethod.isTypeInitializer()) {
                Expression left = node.getLeft();
                Expression right = node.getRight();
                if (left instanceof IndexerExpression && right instanceof PrimitiveExpression) {
                    String mapName = null;
                    Expression array = ((IndexerExpression)left).getTarget();
                    Expression argument = ((IndexerExpression)left).getArgument();
                    if (array instanceof MemberReferenceExpression) {
                        mapName = ((MemberReferenceExpression)array).getMemberName();
                    } else if (array instanceof IdentifierExpression) {
                        mapName = ((IdentifierExpression)array).getIdentifier();
                    }
                    if (mapName == null || mapName.startsWith("$SwitchMap$")) {
                        return (Void)super.visitAssignmentExpression(node, (Object)data);
                    }
                    if (!(argument instanceof InvocationExpression)) {
                        return (Void)super.visitAssignmentExpression(node, (Object)data);
                    }
                    InvocationExpression invocation = (InvocationExpression)argument;
                    Expression invocationTarget = invocation.getTarget();
                    if (!(invocationTarget instanceof MemberReferenceExpression)) {
                        return (Void)super.visitAssignmentExpression(node, (Object)data);
                    }
                    MemberReferenceExpression memberReference = (MemberReferenceExpression)invocationTarget;
                    Expression memberTarget = memberReference.getTarget();
                    if (!(memberTarget instanceof MemberReferenceExpression) || !"ordinal".equals(memberReference.getMemberName())) {
                        return (Void)super.visitAssignmentExpression(node, (Object)data);
                    }
                    MemberReferenceExpression outerMemberReference = (MemberReferenceExpression)memberTarget;
                    Expression outerMemberTarget = outerMemberReference.getTarget();
                    if (!(outerMemberTarget instanceof TypeReferenceExpression)) {
                        return (Void)super.visitAssignmentExpression(node, (Object)data);
                    }
                    String enclosingType = currentType.getInternalName();
                    SwitchMapInfo info = this._switchMaps.get(enclosingType);
                    if (info == null) {
                        info = new SwitchMapInfo(enclosingType);
                        this._switchMaps.put(enclosingType, info);
                        AstBuilder astBuilder = (AstBuilder)this.context.getUserData(Keys.AST_BUILDER);
                        if (astBuilder == null) {
                            astBuilder = new AstBuilder(this.context);
                        }
                        info.enclosingTypeDeclaration = astBuilder.createType(currentType);
                    }
                    PrimitiveExpression value = (PrimitiveExpression)right;
                    assert (value.getValue() instanceof Integer);
                    Map<Integer, Expression> mapping = info.mappings.get(mapName);
                    if (mapping == null) {
                        mapping = new LinkedHashMap<Integer, Expression>();
                        info.mappings.put(mapName, mapping);
                    }
                    IdentifierExpression enumValue = new IdentifierExpression(-34, outerMemberReference.getMemberName());
                    enumValue.putUserData(Keys.MEMBER_REFERENCE, outerMemberReference.getUserData(Keys.MEMBER_REFERENCE));
                    mapping.put(((Number)value.getValue()).intValue(), (Expression)enumValue);
                }
            }
            return (Void)super.visitAssignmentExpression(node, (Object)data);
        }

        private void rewrite() {
            if (this._switchMaps.isEmpty()) {
                return;
            }
            for (SwitchMapInfo info : this._switchMaps.values()) {
                this.rewrite(info);
            }
            block1: for (SwitchMapInfo info : this._switchMaps.values()) {
                for (String mapName : info.switches.keySet()) {
                    List<SwitchStatement> switches = info.switches.get(mapName);
                    if (switches == null || switches.isEmpty()) continue;
                    continue block1;
                }
                TypeDeclaration enclosingTypeDeclaration = info.enclosingTypeDeclaration;
                if (enclosingTypeDeclaration == null) continue;
                enclosingTypeDeclaration.remove();
            }
        }

        private void rewrite(SwitchMapInfo info) {
            if (info.switches.isEmpty()) {
                return;
            }
            for (String mapName : info.switches.keySet()) {
                List<SwitchStatement> switches = info.switches.get(mapName);
                Map<Integer, Expression> mappings = info.mappings.get(mapName);
                if (switches == null || mappings == null) continue;
                for (int i = 0; i < switches.size(); ++i) {
                    if (!this.rewriteSwitch(switches.get(i), mappings)) continue;
                    switches.remove(i--);
                }
            }
        }

        private boolean rewriteSwitch(SwitchStatement s, Map<Integer, Expression> mappings) {
            IdentityHashMap<Expression, Expression> replacements = new IdentityHashMap<Expression, Expression>();
            for (SwitchSection section : s.getSwitchSections()) {
                for (CaseLabel caseLabel : section.getCaseLabels()) {
                    Expression replacement;
                    Object value;
                    Expression expression = caseLabel.getExpression();
                    if (expression.isNull()) continue;
                    if (expression instanceof PrimitiveExpression && (value = ((PrimitiveExpression)expression).getValue()) instanceof Integer && (replacement = mappings.get(value)) != null) {
                        replacements.put(expression, replacement);
                        continue;
                    }
                    return false;
                }
            }
            IndexerExpression indexer = (IndexerExpression)s.getExpression();
            InvocationExpression argument = (InvocationExpression)indexer.getArgument();
            MemberReferenceExpression memberReference = (MemberReferenceExpression)argument.getTarget();
            Expression newTest = memberReference.getTarget();
            newTest.remove();
            indexer.replaceWith((AstNode)newTest);
            for (Map.Entry entry : replacements.entrySet()) {
                ((Expression)entry.getKey()).replaceWith((AstNode)((Expression)entry.getValue()).clone());
            }
            return true;
        }

        private static boolean isSwitchMapWrapper(TypeReference type) {
            TypeDefinition definition;
            if (type == null) {
                return false;
            }
            TypeDefinition typeDefinition = definition = type instanceof TypeDefinition ? (TypeDefinition)type : type.resolve();
            if (!(definition != null && definition.isSynthetic() && definition.isInnerClass() && definition.isPackagePrivate())) {
                return false;
            }
            for (FieldDefinition field : definition.getDeclaredFields()) {
                if (field.getName().startsWith("$SwitchMap$") || !BuiltinTypes.Integer.makeArrayType().equals((Object)field.getFieldType())) continue;
                return true;
            }
            return false;
        }

        private static final class SwitchMapInfo {
            final String enclosingType;
            final Map<String, List<SwitchStatement>> switches = new LinkedHashMap<String, List<SwitchStatement>>();
            final Map<String, Map<Integer, Expression>> mappings = new LinkedHashMap<String, Map<Integer, Expression>>();
            TypeDeclaration enclosingTypeDeclaration;

            SwitchMapInfo(String enclosingType) {
                this.enclosingType = enclosingType;
            }
        }
    }
}

