/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.bytecode.AccessFlags;
import java.lang.reflect.Modifier;

public enum Access {
    PUBLIC,
    PROTECTED,
    PACKAGE,
    PRIVATE;


    public static Access get(AccessFlags flags) {
        return Access.get(flags.getFlags());
    }

    public static Access get(int modifiers) {
        boolean isPublic = Modifier.isPublic(modifiers);
        boolean isProtected = Modifier.isProtected(modifiers);
        boolean isPrivate = Modifier.isPrivate(modifiers);
        if (isPublic && !isProtected && !isPrivate) {
            return PUBLIC;
        }
        if (!isPublic && isProtected && !isPrivate) {
            return PROTECTED;
        }
        if (!isPublic && !isProtected && isPrivate) {
            return PRIVATE;
        }
        if (!(isPublic || isProtected || isPrivate)) {
            return PACKAGE;
        }
        return PUBLIC;
    }
}

