/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MemberMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.throwables.IllegalNameException;

public class FieldMapping
implements Comparable<FieldMapping>,
MemberMapping<FieldEntry> {
    private String obfName;
    private String deobfName;
    private TypeDescriptor obfDesc;
    private Mappings.EntryModifier modifier;

    public FieldMapping(String obfName, TypeDescriptor obfDesc, String deobfName, Mappings.EntryModifier modifier) {
        this.obfName = obfName;
        this.deobfName = NameValidator.validateFieldName(deobfName);
        this.obfDesc = obfDesc;
        this.modifier = modifier;
    }

    @Override
    public FieldEntry getObfEntry(ClassEntry classEntry) {
        return new FieldEntry(classEntry, this.obfName, this.obfDesc);
    }

    @Override
    public String getObfName() {
        return this.obfName;
    }

    public void setObfName(String name) {
        block2: {
            try {
                NameValidator.validateMethodName(name);
            }
            catch (IllegalNameException ex) {
                if (this.deobfName != null) break block2;
                System.err.println("WARNING: " + name + " is conflicting, auto deobfuscate to " + name + "_auto_deob");
                this.setDeobfName(name + "_auto_deob");
            }
        }
        this.obfName = name;
    }

    public String getDeobfName() {
        return this.deobfName;
    }

    public void setDeobfName(String val) {
        this.deobfName = NameValidator.validateFieldName(val);
    }

    public TypeDescriptor getObfDesc() {
        return this.obfDesc;
    }

    public void setObfDesc(TypeDescriptor val) {
        this.obfDesc = val;
    }

    public Mappings.EntryModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Mappings.EntryModifier modifier) {
        this.modifier = modifier;
    }

    @Override
    public int compareTo(FieldMapping other) {
        return (this.obfName + this.obfDesc).compareTo(other.obfName + other.obfDesc);
    }

    public boolean renameObfClass(String oldObfClassName, String newObfClassName) {
        TypeDescriptor newDesc = this.obfDesc.remap(className -> {
            if (className.equals(oldObfClassName)) {
                return newObfClassName;
            }
            return className;
        });
        if (!newDesc.equals(this.obfDesc)) {
            this.obfDesc = newDesc;
            return true;
        }
        return false;
    }
}

