/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableDefEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public interface Translator {
    public ClassEntry getTranslatedClass(ClassEntry var1);

    public ClassDefEntry getTranslatedClassDef(ClassDefEntry var1);

    public FieldEntry getTranslatedField(FieldEntry var1);

    public FieldDefEntry getTranslatedFieldDef(FieldDefEntry var1);

    public MethodEntry getTranslatedMethod(MethodEntry var1);

    public MethodDefEntry getTranslatedMethodDef(MethodDefEntry var1);

    public LocalVariableEntry getTranslatedVariable(LocalVariableEntry var1);

    public LocalVariableDefEntry getTranslatedVariableDef(LocalVariableDefEntry var1);

    public boolean hasClassMapping(ClassEntry var1);

    public boolean hasFieldMapping(FieldEntry var1);

    public boolean hasMethodMapping(MethodEntry var1);

    public boolean hasLocalVariableMapping(LocalVariableEntry var1);

    public TypeDescriptor getTranslatedTypeDesc(TypeDescriptor var1);

    public MethodDescriptor getTranslatedMethodDesc(MethodDescriptor var1);

    public Signature getTranslatedSignature(Signature var1);

    default public Type getTranslatedType(Type type) {
        String descString = type.getDescriptor();
        switch (type.getSort()) {
            case 10: {
                ClassEntry classEntry = new ClassEntry(type.getInternalName());
                return Type.getObjectType((String)this.getTranslatedClass(classEntry).getName());
            }
            case 9: {
                TypeDescriptor descriptor = new TypeDescriptor(descString);
                return Type.getType((String)this.getTranslatedTypeDesc(descriptor).toString());
            }
            case 11: {
                MethodDescriptor descriptor = new MethodDescriptor(descString);
                return Type.getMethodType((String)this.getTranslatedMethodDesc(descriptor).toString());
            }
        }
        return type;
    }

    default public Handle getTranslatedHandle(Handle handle) {
        MethodEntry entry = new MethodEntry(new ClassEntry(handle.getOwner()), handle.getName(), new MethodDescriptor(handle.getDesc()));
        MethodEntry translatedMethod = this.getTranslatedMethod(entry);
        ClassEntry ownerClass = translatedMethod.getOwnerClassEntry();
        return new Handle(handle.getTag(), ownerClass.getName(), translatedMethod.getName(), translatedMethod.getDesc().toString(), handle.isInterface());
    }

    default public Object getTranslatedValue(Object value) {
        if (value instanceof Type) {
            return this.getTranslatedType((Type)value);
        }
        if (value instanceof Handle) {
            return this.getTranslatedHandle((Handle)value);
        }
        return value;
    }

    default public <T extends Entry> T getTranslatedEntry(T entry) {
        if (entry instanceof ClassDefEntry) {
            return (T)this.getTranslatedClassDef((ClassDefEntry)entry);
        }
        if (entry instanceof ClassEntry) {
            return (T)this.getTranslatedClass((ClassEntry)entry);
        }
        if (entry instanceof FieldDefEntry) {
            return (T)this.getTranslatedFieldDef((FieldDefEntry)entry);
        }
        if (entry instanceof MethodDefEntry) {
            return (T)this.getTranslatedMethodDef((MethodDefEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return (T)this.getTranslatedField((FieldEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return (T)this.getTranslatedMethod((MethodEntry)entry);
        }
        if (entry instanceof LocalVariableDefEntry) {
            return (T)this.getTranslatedVariableDef((LocalVariableDefEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return (T)this.getTranslatedVariable((LocalVariableEntry)entry);
        }
        if (entry instanceof TypeDescriptor) {
            return (T)((Entry)((Object)this.getTranslatedTypeDesc((TypeDescriptor)((Object)entry))));
        }
        if (entry instanceof MethodDescriptor) {
            return (T)((Entry)((Object)this.getTranslatedMethodDesc((MethodDescriptor)((Object)entry))));
        }
        throw new IllegalArgumentException("Cannot translate unknown entry type");
    }
}

