/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntryRenamer {
    public static <T> void renameClassesInSet(Map<String, String> renames, Set<T> set) {
        ArrayList entries = Lists.newArrayList();
        for (T val : set) {
            entries.add(EntryRenamer.renameClassesInThing(renames, val));
        }
        set.clear();
        set.addAll(entries);
    }

    public static <Key, Val> void renameClassesInMap(Map<String, String> renames, Map<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry<Key, Val>(EntryRenamer.renameClassesInThing(renames, entry.getKey()), EntryRenamer.renameClassesInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry<Object, Object> entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameClassesInMultimap(Map<String, String> renames, Multimap<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry entry : map.entries()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry(EntryRenamer.renameClassesInThing(renames, entry.getKey()), EntryRenamer.renameClassesInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameMethodsInMultimap(Map<MethodEntry, MethodEntry> renames, Multimap<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry entry : map.entries()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry(EntryRenamer.renameMethodsInThing(renames, entry.getKey()), EntryRenamer.renameMethodsInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <Key, Val> void renameMethodsInMap(Map<MethodEntry, MethodEntry> renames, Map<Key, Val> map) {
        HashSet entriesToAdd = Sets.newHashSet();
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            entriesToAdd.add(new AbstractMap.SimpleEntry<Key, Val>(EntryRenamer.renameMethodsInThing(renames, entry.getKey()), EntryRenamer.renameMethodsInThing(renames, entry.getValue())));
        }
        map.clear();
        for (Map.Entry<Object, Object> entry : entriesToAdd) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <T> T renameMethodsInThing(Map<MethodEntry, MethodEntry> renames, T thing) {
        if (thing instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)thing;
            MethodEntry newMethodEntry = renames.get(methodEntry);
            if (newMethodEntry != null) {
                return (T)new MethodEntry(methodEntry.getOwnerClassEntry(), newMethodEntry.getName(), methodEntry.getDesc());
            }
            return thing;
        }
        if (thing instanceof LocalVariableEntry) {
            LocalVariableEntry variableEntry = (LocalVariableEntry)thing;
            return (T)new LocalVariableEntry(EntryRenamer.renameMethodsInThing(renames, variableEntry.getOwnerEntry()), variableEntry.getIndex(), variableEntry.getName(), variableEntry.isParameter());
        }
        if (thing instanceof EntryReference) {
            EntryReference reference = (EntryReference)thing;
            reference.entry = (Entry)EntryRenamer.renameMethodsInThing(renames, reference.entry);
            reference.context = (Entry)EntryRenamer.renameMethodsInThing(renames, reference.context);
            return thing;
        }
        return thing;
    }

    public static <T> T renameClassesInThing(Map<String, String> renames, T thing) {
        if (thing instanceof String) {
            String stringEntry = (String)thing;
            if (renames.containsKey(stringEntry)) {
                return (T)renames.get(stringEntry);
            }
        } else {
            if (thing instanceof ClassEntry) {
                ClassEntry classEntry = (ClassEntry)thing;
                return (T)new ClassEntry(EntryRenamer.renameClassesInThing(renames, classEntry.getClassName()));
            }
            if (thing instanceof FieldDefEntry) {
                FieldDefEntry fieldEntry = (FieldDefEntry)thing;
                return (T)new FieldDefEntry(EntryRenamer.renameClassesInThing(renames, fieldEntry.getOwnerClassEntry()), fieldEntry.getName(), EntryRenamer.renameClassesInThing(renames, fieldEntry.getDesc()), EntryRenamer.renameClassesInThing(renames, fieldEntry.getSignature()), fieldEntry.getAccess());
            }
            if (thing instanceof MethodDefEntry) {
                MethodDefEntry methodEntry = (MethodDefEntry)thing;
                return (T)new MethodDefEntry(EntryRenamer.renameClassesInThing(renames, methodEntry.getOwnerClassEntry()), methodEntry.getName(), EntryRenamer.renameClassesInThing(renames, methodEntry.getDesc()), EntryRenamer.renameClassesInThing(renames, methodEntry.getSignature()), methodEntry.getAccess());
            }
            if (thing instanceof MethodEntry) {
                MethodEntry methodEntry = (MethodEntry)thing;
                return (T)new MethodEntry(EntryRenamer.renameClassesInThing(renames, methodEntry.getOwnerClassEntry()), methodEntry.getName(), EntryRenamer.renameClassesInThing(renames, methodEntry.getDesc()));
            }
            if (thing instanceof LocalVariableEntry) {
                LocalVariableEntry argumentEntry = (LocalVariableEntry)thing;
                return (T)new LocalVariableEntry(EntryRenamer.renameClassesInThing(renames, argumentEntry.getOwnerEntry()), argumentEntry.getIndex(), argumentEntry.getName(), argumentEntry.isParameter());
            }
            if (thing instanceof EntryReference) {
                EntryReference reference = (EntryReference)thing;
                reference.entry = (Entry)EntryRenamer.renameClassesInThing(renames, reference.entry);
                reference.context = (Entry)EntryRenamer.renameClassesInThing(renames, reference.context);
                return thing;
            }
            if (thing instanceof MethodDescriptor) {
                return (T)((MethodDescriptor)thing).remap(className -> EntryRenamer.renameClassesInThing(renames, className));
            }
            if (thing instanceof TypeDescriptor) {
                return (T)((TypeDescriptor)thing).remap(className -> EntryRenamer.renameClassesInThing(renames, className));
            }
            if (thing instanceof Signature) {
                return (T)((Signature)thing).remap(className -> EntryRenamer.renameClassesInThing(renames, className));
            }
        }
        return thing;
    }
}

