/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import javax.swing.tree.DefaultMutableTreeNode;

public class FieldReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<FieldEntry, MethodDefEntry> {
    private Translator deobfuscatingTranslator;
    private FieldEntry entry;
    private EntryReference<FieldEntry, MethodDefEntry> reference;
    private AccessFlags access;

    public FieldReferenceTreeNode(Translator deobfuscatingTranslator, FieldEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    private FieldReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<FieldEntry, MethodDefEntry> reference, AccessFlags access) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (FieldEntry)reference.entry;
        this.reference = reference;
        this.access = access;
    }

    @Override
    public FieldEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<FieldEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s (%s)", this.deobfuscatingTranslator.getTranslatedMethodDef((MethodDefEntry)this.reference.context), this.access);
        }
        return this.deobfuscatingTranslator.getTranslatedField(this.entry).getName();
    }

    public void load(JarIndex index, boolean recurse) {
        if (this.reference == null) {
            for (EntryReference<Entry, MethodDefEntry> entryReference : index.getFieldReferences(this.entry)) {
                this.add(new FieldReferenceTreeNode(this.deobfuscatingTranslator, entryReference, index.getAccessFlags(this.entry)));
            }
        } else {
            for (EntryReference<Entry, MethodDefEntry> entryReference : index.getMethodsReferencing((MethodEntry)this.reference.context)) {
                this.add(new MethodReferenceTreeNode(this.deobfuscatingTranslator, entryReference, index.getAccessFlags((Entry)this.reference.context)));
            }
        }
        if (recurse && this.children != null) {
            for (EntryReference<Entry, MethodDefEntry> entryReference : this.children) {
                if (entryReference instanceof MethodReferenceTreeNode) {
                    ((MethodReferenceTreeNode)((Object)entryReference)).load(index, true);
                    continue;
                }
                if (!(entryReference instanceof FieldReferenceTreeNode)) continue;
                ((FieldReferenceTreeNode)((Object)entryReference)).load(index, true);
            }
        }
    }
}

