/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.analysis.Access;
import java.lang.reflect.Modifier;

public class AccessFlags {
    private int flags;

    public AccessFlags(int flags) {
        this.flags = flags;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isSynthetic() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isEnum() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean isBridge() {
        return (this.flags & 0x40) != 0;
    }

    public AccessFlags setPrivate() {
        this.setVisibility(2);
        return this;
    }

    public AccessFlags setProtected() {
        this.setVisibility(4);
        return this;
    }

    public AccessFlags setPublic() {
        this.setVisibility(1);
        return this;
    }

    public AccessFlags setBridge() {
        this.flags |= 0x40;
        return this;
    }

    @Deprecated
    public AccessFlags setBridged() {
        return this.setBridge();
    }

    public void setVisibility(int visibility) {
        this.resetVisibility();
        this.flags |= visibility;
    }

    private void resetVisibility() {
        this.flags &= 0xFFFFFFF8;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        return obj instanceof AccessFlags && ((AccessFlags)obj).flags == this.flags;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Access.get(this).toString().toLowerCase());
        if (this.isStatic()) {
            builder.append(" static");
        }
        if (this.isSynthetic()) {
            builder.append(" synthetic");
        }
        if (this.isBridge()) {
            builder.append(" bridge");
        }
        return builder.toString();
    }
}

