/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.bytecode.translators.TranslationAnnotationVisitor;
import cuchaz.enigma.bytecode.translators.TranslationFieldVisitor;
import cuchaz.enigma.bytecode.translators.TranslationMethodVisitor;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class TranslationClassVisitor
extends ClassVisitor {
    private final Translator translator;
    private final JarIndex jarIndex;
    private final ReferencedEntryPool entryPool;
    private ClassDefEntry obfClassEntry;
    private Signature obfSignature;

    public TranslationClassVisitor(Translator translator, JarIndex jarIndex, ReferencedEntryPool entryPool, int api, ClassVisitor cv) {
        super(api, cv);
        this.translator = translator;
        this.jarIndex = jarIndex;
        this.entryPool = entryPool;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.obfSignature = Signature.createSignature(signature);
        this.obfClassEntry = new ClassDefEntry(name, this.obfSignature, new AccessFlags(access));
        ClassDefEntry translatedEntry = this.translator.getTranslatedClassDef(this.obfClassEntry);
        ClassEntry superEntry = this.translator.getTranslatedClass(this.entryPool.getClass(superName));
        String[] translatedInterfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            translatedInterfaces[i] = this.translator.getTranslatedClass(this.entryPool.getClass(interfaces[i])).getName();
        }
        super.visit(version, translatedEntry.getAccess().getFlags(), translatedEntry.getName(), translatedEntry.getSignature().toString(), superEntry.getName(), translatedInterfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDefEntry entry = new FieldDefEntry(this.obfClassEntry, name, new TypeDescriptor(desc), Signature.createTypedSignature(signature), new AccessFlags(access));
        FieldDefEntry translatedEntry = this.translator.getTranslatedFieldDef(entry);
        FieldVisitor fv = super.visitField(translatedEntry.getAccess().getFlags(), translatedEntry.getName(), translatedEntry.getDesc().toString(), translatedEntry.getSignature().toString(), value);
        return new TranslationFieldVisitor(this.translator, translatedEntry, this.api, fv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDefEntry entry = new MethodDefEntry(this.obfClassEntry, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        MethodDefEntry translatedEntry = this.translator.getTranslatedMethodDef(entry);
        if (this.jarIndex.getBridgedMethod(entry) != null) {
            translatedEntry.getAccess().setBridge();
        }
        String[] translatedExceptions = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            translatedExceptions[i] = this.translator.getTranslatedClass(this.entryPool.getClass(exceptions[i])).getName();
        }
        MethodVisitor mv = super.visitMethod(translatedEntry.getAccess().getFlags(), translatedEntry.getName(), translatedEntry.getDesc().toString(), translatedEntry.getSignature().toString(), translatedExceptions);
        return new TranslationMethodVisitor(this.translator, this.obfClassEntry, entry, this.api, mv);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        ClassDefEntry translatedEntry = this.translator.getTranslatedClassDef(new ClassDefEntry(name, this.obfSignature, new AccessFlags(access)));
        String translatedName = translatedEntry.getName();
        int separatorIndex = translatedName.lastIndexOf("$");
        String parentName = translatedName.substring(0, separatorIndex);
        String childName = translatedName.substring(separatorIndex + 1);
        ClassEntry outerEntry = this.translator.getTranslatedClass(this.entryPool.getClass(parentName));
        String translatedOuterName = outerName != null ? outerEntry.getName() : null;
        String translatedInnerName = innerName != null ? childName : null;
        super.visitInnerClass(translatedName, translatedOuterName, translatedInnerName, translatedEntry.getAccess().getFlags());
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (desc != null) {
            MethodEntry translatedEntry = this.translator.getTranslatedMethod(new MethodEntry(new ClassEntry(owner), name, new MethodDescriptor(desc)));
            super.visitOuterClass(translatedEntry.getClassName(), translatedEntry.getName(), translatedEntry.getDesc().toString());
        } else {
            super.visitOuterClass(owner, name, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        TypeDescriptor translatedDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
        AnnotationVisitor av = super.visitAnnotation(translatedDesc.toString(), visible);
        return new TranslationAnnotationVisitor(this.translator, translatedDesc.getTypeEntry(), this.api, av);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeDescriptor translatedDesc = this.translator.getTranslatedTypeDesc(new TypeDescriptor(desc));
        AnnotationVisitor av = super.visitTypeAnnotation(typeRef, typePath, translatedDesc.toString(), visible);
        return new TranslationAnnotationVisitor(this.translator, translatedDesc.getTypeEntry(), this.api, av);
    }
}

