/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.throwables.MappingConflict;
import java.util.ArrayList;
import java.util.Map;

public class ClassMapping
implements Comparable<ClassMapping> {
    private String obfFullName;
    private String obfSimpleName;
    private String deobfName;
    private String deobfFullName;
    private String previousDeobfName;
    private Map<String, ClassMapping> innerClassesByObfSimple;
    private Map<String, ClassMapping> innerClassesByObfFull;
    private Map<String, ClassMapping> innerClassesByDeobf;
    private Map<String, FieldMapping> fieldsByObf;
    private Map<String, FieldMapping> fieldsByDeobf;
    private Map<String, MethodMapping> methodsByObf;
    private Map<String, MethodMapping> methodsByDeobf;
    private boolean isDirty;
    private Mappings.EntryModifier modifier;

    public ClassMapping(String obfFullName) {
        this(obfFullName, null, Mappings.EntryModifier.UNCHANGED);
    }

    public ClassMapping(String obfFullName, String deobfName) {
        this(obfFullName, deobfName, Mappings.EntryModifier.UNCHANGED);
    }

    public ClassMapping(String obfFullName, String deobfName, Mappings.EntryModifier modifier) {
        this.obfFullName = obfFullName;
        ClassEntry classEntry = new ClassEntry(obfFullName);
        this.obfSimpleName = classEntry.isInnerClass() ? classEntry.getInnermostClassName() : classEntry.getSimpleName();
        this.previousDeobfName = null;
        this.deobfName = NameValidator.validateClassName(deobfName, false);
        this.innerClassesByObfSimple = Maps.newHashMap();
        this.innerClassesByObfFull = Maps.newHashMap();
        this.innerClassesByDeobf = Maps.newHashMap();
        this.fieldsByObf = Maps.newHashMap();
        this.fieldsByDeobf = Maps.newHashMap();
        this.methodsByObf = Maps.newHashMap();
        this.methodsByDeobf = Maps.newHashMap();
        this.isDirty = true;
        this.modifier = modifier;
    }

    public static boolean isSimpleClassName(String name) {
        return name.indexOf(47) < 0 && name.indexOf(36) < 0;
    }

    public String getObfFullName() {
        return this.obfFullName;
    }

    public String getObfSimpleName() {
        return this.obfSimpleName;
    }

    public String getPreviousDeobfName() {
        return this.previousDeobfName;
    }

    public String getDeobfName() {
        return this.deobfName;
    }

    public String getTranslatedName(TranslationDirection direction) {
        return direction.choose(this.deobfName, this.obfFullName);
    }

    public void setDeobfName(String val) {
        this.previousDeobfName = this.deobfName;
        this.deobfName = NameValidator.validateClassName(val, false);
        this.isDirty = true;
    }

    public Iterable<ClassMapping> innerClasses() {
        assert (this.innerClassesByObfSimple.size() >= this.innerClassesByDeobf.size());
        return this.innerClassesByObfSimple.values();
    }

    public void addInnerClassMapping(ClassMapping classMapping) throws MappingConflict {
        if (this.innerClassesByObfFull.containsKey(classMapping.getObfSimpleName())) {
            throw new MappingConflict("classes", classMapping.getObfSimpleName(), this.innerClassesByObfSimple.get(classMapping.getObfSimpleName()).getObfSimpleName());
        }
        this.innerClassesByObfFull.put(classMapping.getObfFullName(), classMapping);
        this.innerClassesByObfSimple.put(classMapping.getObfSimpleName(), classMapping);
        if (classMapping.getDeobfName() != null) {
            if (this.innerClassesByDeobf.containsKey(classMapping.getDeobfName())) {
                throw new MappingConflict("classes", classMapping.getDeobfName(), this.innerClassesByDeobf.get(classMapping.getDeobfName()).getDeobfName());
            }
            this.innerClassesByDeobf.put(classMapping.getDeobfName(), classMapping);
        }
        this.isDirty = true;
    }

    public void removeInnerClassMapping(ClassMapping classMapping) {
        boolean obfWasRemoved;
        this.innerClassesByObfFull.remove(classMapping.getObfFullName());
        boolean bl = obfWasRemoved = this.innerClassesByObfSimple.remove(classMapping.getObfSimpleName()) != null;
        assert (obfWasRemoved);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public ClassMapping getOrCreateInnerClass(ClassEntry obfInnerClass) {
        ClassMapping classMapping = this.innerClassesByObfSimple.get(obfInnerClass.getInnermostClassName());
        if (classMapping == null) {
            boolean wasAdded;
            classMapping = new ClassMapping(obfInnerClass.getName());
            this.innerClassesByObfFull.put(classMapping.getObfFullName(), classMapping);
            boolean bl = wasAdded = this.innerClassesByObfSimple.put(classMapping.getObfSimpleName(), classMapping) == null;
            assert (wasAdded);
            this.isDirty = true;
        }
        return classMapping;
    }

    public ClassMapping getInnerClassByObfSimple(String obfSimpleName) {
        assert (ClassMapping.isSimpleClassName(obfSimpleName));
        return this.innerClassesByObfSimple.get(obfSimpleName);
    }

    public ClassMapping getInnerClassByDeobf(String deobfName) {
        assert (ClassMapping.isSimpleClassName(deobfName));
        return this.innerClassesByDeobf.get(deobfName);
    }

    public ClassMapping getInnerClassByDeobfThenObfSimple(String name) {
        ClassMapping classMapping = this.getInnerClassByDeobf(name);
        if (classMapping == null) {
            classMapping = this.getInnerClassByObfSimple(name);
        }
        return classMapping;
    }

    public String getDeobfInnerClassName(String obfSimpleName) {
        assert (ClassMapping.isSimpleClassName(obfSimpleName));
        ClassMapping classMapping = this.innerClassesByObfSimple.get(obfSimpleName);
        if (classMapping != null) {
            return classMapping.getDeobfName();
        }
        return null;
    }

    public void setInnerClassName(ClassEntry obfInnerClass, String deobfName) {
        ClassMapping classMapping = this.getOrCreateInnerClass(obfInnerClass);
        if (classMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (wasRemoved);
        }
        classMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            assert (ClassMapping.isSimpleClassName(deobfName));
            boolean bl = wasAdded = this.innerClassesByDeobf.put(deobfName, classMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public boolean hasInnerClassByObfSimple(String obfSimpleName) {
        return this.innerClassesByObfSimple.containsKey(obfSimpleName);
    }

    public boolean hasInnerClassByDeobf(String deobfName) {
        return this.innerClassesByDeobf.containsKey(deobfName);
    }

    public Iterable<FieldMapping> fields() {
        assert (this.fieldsByObf.size() == this.fieldsByDeobf.size());
        return this.fieldsByObf.values();
    }

    public boolean containsObfField(String obfName, TypeDescriptor obfDesc) {
        return this.fieldsByObf.containsKey(this.getFieldKey(obfName, obfDesc));
    }

    public boolean containsDeobfField(String deobfName, TypeDescriptor deobfDesc) {
        return this.fieldsByDeobf.containsKey(this.getFieldKey(deobfName, deobfDesc));
    }

    public void addFieldMapping(FieldMapping fieldMapping) {
        boolean obfWasAdded;
        String obfKey = this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfDesc());
        if (this.fieldsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.obfFullName + "." + obfKey);
        }
        if (fieldMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            String deobfKey = this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfDesc());
            if (this.fieldsByDeobf.containsKey(deobfKey)) {
                throw new Error("Already have mapping for " + this.deobfName + "." + deobfKey);
            }
            boolean bl = deobfWasAdded = this.fieldsByDeobf.put(deobfKey, fieldMapping) == null;
            assert (deobfWasAdded);
        }
        boolean bl = obfWasAdded = this.fieldsByObf.put(obfKey, fieldMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public void removeFieldMapping(FieldMapping fieldMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.fieldsByObf.remove(this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfDesc())) != null;
        assert (obfWasRemoved);
        if (fieldMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfDesc())) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public FieldMapping getFieldByObf(String obfName, TypeDescriptor obfDesc) {
        return this.fieldsByObf.get(this.getFieldKey(obfName, obfDesc));
    }

    public FieldMapping getFieldByObf(FieldEntry field) {
        return this.getFieldByObf(field.getName(), field.getDesc());
    }

    public FieldMapping getFieldByDeobf(String deobfName, TypeDescriptor obfDesc) {
        return this.fieldsByDeobf.get(this.getFieldKey(deobfName, obfDesc));
    }

    public String getObfFieldName(String deobfName, TypeDescriptor obfDesc) {
        FieldMapping fieldMapping = this.fieldsByDeobf.get(this.getFieldKey(deobfName, obfDesc));
        if (fieldMapping != null) {
            return fieldMapping.getObfName();
        }
        return null;
    }

    public String getDeobfFieldName(String obfName, TypeDescriptor obfDesc) {
        FieldMapping fieldMapping = this.fieldsByObf.get(this.getFieldKey(obfName, obfDesc));
        if (fieldMapping != null) {
            return fieldMapping.getDeobfName();
        }
        return null;
    }

    private String getFieldKey(String name, TypeDescriptor desc) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc cannot be null!");
        }
        return name + ":" + desc;
    }

    public void setFieldName(String obfName, TypeDescriptor obfDesc, String deobfName) {
        assert (deobfName != null);
        FieldMapping fieldMapping = this.fieldsByObf.get(this.getFieldKey(obfName, obfDesc));
        if (fieldMapping == null) {
            boolean obfWasAdded;
            fieldMapping = new FieldMapping(obfName, obfDesc, deobfName, Mappings.EntryModifier.UNCHANGED);
            boolean bl = obfWasAdded = this.fieldsByObf.put(this.getFieldKey(obfName, obfDesc), fieldMapping) == null;
            assert (obfWasAdded);
        } else {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), obfDesc)) != null;
            assert (wasRemoved);
        }
        fieldMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.fieldsByDeobf.put(this.getFieldKey(deobfName, obfDesc), fieldMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public void setFieldObfNameAndType(String oldObfName, TypeDescriptor obfDesc, String newObfName, TypeDescriptor newObfDesc) {
        boolean obfWasAdded;
        assert (newObfName != null);
        FieldMapping fieldMapping = this.fieldsByObf.remove(this.getFieldKey(oldObfName, obfDesc));
        assert (fieldMapping != null);
        fieldMapping.setObfName(newObfName);
        fieldMapping.setObfDesc(newObfDesc);
        boolean bl = obfWasAdded = this.fieldsByObf.put(this.getFieldKey(newObfName, newObfDesc), fieldMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public Iterable<MethodMapping> methods() {
        assert (this.methodsByObf.size() >= this.methodsByDeobf.size());
        return this.methodsByObf.values();
    }

    public boolean containsObfMethod(String obfName, MethodDescriptor obfDescriptor) {
        return this.methodsByObf.containsKey(this.getMethodKey(obfName, obfDescriptor));
    }

    public boolean containsDeobfMethod(String deobfName, MethodDescriptor obfDescriptor) {
        return this.methodsByDeobf.containsKey(this.getMethodKey(deobfName, obfDescriptor));
    }

    public void addMethodMapping(MethodMapping methodMapping) {
        boolean wasAdded;
        String obfKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfDesc());
        if (this.methodsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.obfFullName + "." + obfKey);
        }
        boolean bl = wasAdded = this.methodsByObf.put(obfKey, methodMapping) == null;
        assert (wasAdded);
        if (!methodMapping.isObfuscated()) {
            boolean deobfWasAdded;
            String deobfKey = this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfDesc());
            if (this.methodsByDeobf.containsKey(deobfKey)) {
                throw new Error("Already have mapping for " + this.deobfName + "." + deobfKey);
            }
            boolean bl2 = deobfWasAdded = this.methodsByDeobf.put(deobfKey, methodMapping) == null;
            assert (deobfWasAdded);
        }
        this.isDirty = true;
        assert (this.methodsByObf.size() >= this.methodsByDeobf.size());
    }

    public void removeMethodMapping(MethodMapping methodMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.methodsByObf.remove(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfDesc())) != null;
        assert (obfWasRemoved);
        if (!methodMapping.isObfuscated()) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfDesc())) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public MethodMapping getMethodByObf(String obfName, MethodDescriptor obfDescriptor) {
        return this.methodsByObf.get(this.getMethodKey(obfName, obfDescriptor));
    }

    public MethodMapping getMethodByObf(MethodEntry method) {
        return this.getMethodByObf(method.getName(), method.getDesc());
    }

    public MethodMapping getMethodByDeobf(String deobfName, MethodDescriptor obfDescriptor) {
        return this.methodsByDeobf.get(this.getMethodKey(deobfName, obfDescriptor));
    }

    private String getMethodKey(String name, MethodDescriptor descriptor) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null!");
        }
        return name + descriptor;
    }

    public void setMethodName(String obfName, MethodDescriptor obfDescriptor, String deobfName) {
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfName, obfDescriptor));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfName, obfDescriptor);
        } else if (!methodMapping.isObfuscated()) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfDesc())) != null;
            assert (wasRemoved);
        }
        methodMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.methodsByDeobf.put(this.getMethodKey(deobfName, obfDescriptor), methodMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public void setMethodObfNameAndSignature(String oldObfName, MethodDescriptor obfDescriptor, String newObfName, MethodDescriptor newObfDescriptor) {
        boolean obfWasAdded;
        assert (newObfName != null);
        MethodMapping methodMapping = this.methodsByObf.remove(this.getMethodKey(oldObfName, obfDescriptor));
        assert (methodMapping != null);
        methodMapping.setObfName(newObfName);
        methodMapping.setObfDescriptor(newObfDescriptor);
        boolean bl = obfWasAdded = this.methodsByObf.put(this.getMethodKey(newObfName, newObfDescriptor), methodMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public void setArgumentName(String obfMethodName, MethodDescriptor obfMethodDescriptor, int argumentIndex, String argumentName) {
        assert (argumentName != null);
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodDescriptor));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfMethodName, obfMethodDescriptor);
        }
        methodMapping.setLocalVariableName(argumentIndex, argumentName);
        this.isDirty = true;
    }

    public void removeArgumentName(String obfMethodName, MethodDescriptor obfMethodDescriptor, int argumentIndex) {
        this.methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodDescriptor)).removeLocalVariableName(argumentIndex);
        this.isDirty = true;
    }

    private MethodMapping createMethodMapping(String obfName, MethodDescriptor obfDescriptor) {
        boolean wasAdded;
        MethodMapping methodMapping = new MethodMapping(obfName, obfDescriptor);
        boolean bl = wasAdded = this.methodsByObf.put(this.getMethodKey(obfName, obfDescriptor), methodMapping) == null;
        assert (wasAdded);
        this.isDirty = true;
        return methodMapping;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.obfFullName);
        buf.append(" <-> ");
        buf.append(this.deobfName);
        buf.append("\n");
        buf.append("Fields:\n");
        for (FieldMapping fieldMapping : this.fields()) {
            buf.append("\t");
            buf.append(fieldMapping.getObfName());
            buf.append(" <-> ");
            buf.append(fieldMapping.getDeobfName());
            buf.append("\n");
        }
        buf.append("Methods:\n");
        for (MethodMapping methodMapping : this.methodsByObf.values()) {
            buf.append(methodMapping);
            buf.append("\n");
        }
        buf.append("Inner Classes:\n");
        for (ClassMapping classMapping : this.innerClassesByObfSimple.values()) {
            buf.append("\t");
            buf.append(classMapping.getObfSimpleName());
            buf.append(" <-> ");
            buf.append(classMapping.getDeobfName());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(ClassMapping other) {
        if (this.obfFullName.length() != other.obfFullName.length()) {
            return this.obfFullName.length() - other.obfFullName.length();
        }
        return this.obfFullName.compareTo(other.obfFullName);
    }

    public boolean renameObfClass(String oldObfClassName, String newObfClassName) {
        boolean wasAdded;
        boolean wasRemoved;
        for (ClassMapping innerClassMapping : new ArrayList<ClassMapping>(this.innerClassesByObfSimple.values())) {
            boolean wasAdded2;
            boolean wasRemoved2;
            if (!innerClassMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved2 = this.innerClassesByObfSimple.remove(oldObfClassName) != null;
            assert (wasRemoved2);
            boolean bl2 = wasAdded2 = this.innerClassesByObfSimple.put(newObfClassName, innerClassMapping) == null;
            assert (wasAdded2);
        }
        for (FieldMapping fieldMapping : new ArrayList<FieldMapping>(this.fieldsByObf.values())) {
            String oldFieldKey = this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfDesc());
            if (!fieldMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.fieldsByObf.remove(oldFieldKey) != null;
            assert (wasRemoved);
            boolean bl3 = wasAdded = this.fieldsByObf.put(this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfDesc()), fieldMapping) == null;
            assert (wasAdded);
        }
        for (MethodMapping methodMapping : new ArrayList<MethodMapping>(this.methodsByObf.values())) {
            String oldMethodKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfDesc());
            if (!methodMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.methodsByObf.remove(oldMethodKey) != null;
            assert (wasRemoved);
            boolean bl4 = wasAdded = this.methodsByObf.put(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfDesc()), methodMapping) == null;
            assert (wasAdded);
        }
        if (this.obfFullName.equals(oldObfClassName)) {
            this.obfFullName = newObfClassName;
            return true;
        }
        this.isDirty = true;
        return false;
    }

    public boolean containsArgument(MethodEntry obfMethodEntry, String name) {
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfMethodEntry.getName(), obfMethodEntry.getDesc()));
        return methodMapping != null && methodMapping.containsLocalVariable(name);
    }

    public ClassEntry getObfEntry() {
        return new ClassEntry(this.obfFullName);
    }

    public ClassEntry getDeObfEntry() {
        return this.deobfFullName != null ? new ClassEntry(this.deobfFullName) : null;
    }

    public boolean isObfuscated() {
        return this.deobfName == null || this.deobfName.equals(this.obfFullName);
    }

    public String getSaveName() {
        return this.isObfuscated() ? this.obfFullName : this.deobfName;
    }

    public boolean isDirty() {
        return this.isDirty || this.areInnersDirty();
    }

    private boolean areInnersDirty() {
        for (ClassMapping c : this.innerClasses()) {
            if (!c.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public Mappings.EntryModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Mappings.EntryModifier modifier) {
        if (this.modifier != modifier) {
            this.isDirty = true;
        }
        this.modifier = modifier;
    }

    public void setFieldModifier(String obfName, TypeDescriptor obfDesc, Mappings.EntryModifier modifier) {
        FieldMapping fieldMapping = this.fieldsByObf.computeIfAbsent(this.getFieldKey(obfName, obfDesc), k -> new FieldMapping(obfName, obfDesc, null, Mappings.EntryModifier.UNCHANGED));
        if (fieldMapping.getModifier() != modifier) {
            fieldMapping.setModifier(modifier);
            this.isDirty = true;
        }
    }

    public void setMethodModifier(String obfName, MethodDescriptor sig, Mappings.EntryModifier modifier) {
        MethodMapping methodMapping = this.methodsByObf.computeIfAbsent(this.getMethodKey(obfName, sig), k -> new MethodMapping(obfName, sig, null, Mappings.EntryModifier.UNCHANGED));
        if (methodMapping.getModifier() != modifier) {
            methodMapping.setModifier(modifier);
            this.isDirty = true;
        }
    }

    public ClassMapping setDeobfInner(String deobName) {
        this.deobfFullName = deobName;
        return this;
    }

    public ClassMapping copy() {
        ClassMapping copied = new ClassMapping(this.obfFullName);
        copied.obfSimpleName = this.obfSimpleName;
        copied.modifier = this.modifier;
        copied.deobfFullName = this.deobfFullName;
        copied.deobfName = this.deobfName;
        copied.innerClassesByDeobf = this.innerClassesByDeobf;
        copied.innerClassesByObfFull = this.innerClassesByObfFull;
        copied.innerClassesByObfSimple = this.innerClassesByObfSimple;
        copied.fieldsByObf = this.fieldsByObf;
        copied.fieldsByDeobf = this.fieldsByDeobf;
        copied.methodsByObf = this.methodsByObf;
        copied.methodsByDeobf = this.methodsByDeobf;
        return copied;
    }

    public int hashCode() {
        return this.obfFullName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassMapping && ((ClassMapping)obj).obfFullName.equals(this.obfFullName);
    }

    public boolean isEmpty() {
        if (this.fieldsByDeobf.isEmpty() && this.methodsByDeobf.isEmpty() && this.deobfFullName == null && this.deobfName == null && this.innerClassesByObfSimple.values().stream().allMatch(ClassMapping::isEmpty)) {
            for (MethodMapping mapping : this.methodsByObf.values()) {
                if (!mapping.arguments().iterator().hasNext()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

