/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.base.Charsets;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MappingsSRGWriter {
    public void write(File file, Mappings mappings) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        TranslationIndex index = new TranslationIndex(new ReferencedEntryPool());
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8));
        ArrayList<String> fieldMappings = new ArrayList<String>();
        ArrayList<String> methodMappings = new ArrayList<String>();
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            if (classMapping.getDeobfName() == null || classMapping.getObfSimpleName() == null || classMapping.getDeobfName() == null) continue;
            writer.write("CL: " + classMapping.getObfSimpleName() + " " + classMapping.getDeobfName());
            writer.write(System.lineSeparator());
            for (ClassMapping innerClassMapping : this.sorted(classMapping.innerClasses())) {
                if (innerClassMapping.getDeobfName() == null || innerClassMapping.getObfSimpleName() == null || innerClassMapping.getDeobfName() == null) continue;
                String innerClassName = classMapping.getObfSimpleName() + "$" + innerClassMapping.getObfSimpleName();
                String innerDeobfClassName = classMapping.getDeobfName() + "$" + innerClassMapping.getDeobfName();
                writer.write("CL: " + innerClassName + " " + classMapping.getDeobfName() + "$" + innerClassMapping.getDeobfName());
                writer.write(System.lineSeparator());
                for (FieldMapping fieldMapping : this.sorted(innerClassMapping.fields())) {
                    fieldMappings.add("FD: " + innerClassName + "/" + fieldMapping.getObfName() + " " + innerDeobfClassName + "/" + fieldMapping.getDeobfName());
                }
                for (MethodMapping methodMapping : this.sorted(innerClassMapping.methods())) {
                    methodMappings.add("MD: " + innerClassName + "/" + methodMapping.getObfName() + " " + methodMapping.getObfDesc() + " " + innerDeobfClassName + "/" + methodMapping.getDeobfName() + " " + mappings.getTranslator(TranslationDirection.DEOBFUSCATING, index).getTranslatedMethodDesc(methodMapping.getObfDesc()));
                }
            }
            for (FieldMapping fieldMapping : this.sorted(classMapping.fields())) {
                fieldMappings.add("FD: " + classMapping.getObfFullName() + "/" + fieldMapping.getObfName() + " " + classMapping.getDeobfName() + "/" + fieldMapping.getDeobfName());
            }
            for (MethodMapping methodMapping : this.sorted(classMapping.methods())) {
                methodMappings.add("MD: " + classMapping.getObfFullName() + "/" + methodMapping.getObfName() + " " + methodMapping.getObfDesc() + " " + classMapping.getDeobfName() + "/" + methodMapping.getDeobfName() + " " + mappings.getTranslator(TranslationDirection.DEOBFUSCATING, index).getTranslatedMethodDesc(methodMapping.getObfDesc()));
            }
        }
        for (String fd : fieldMappings) {
            writer.write(fd);
            writer.write(System.lineSeparator());
        }
        for (String md : methodMappings) {
            writer.write(md);
            writer.write(System.lineSeparator());
        }
        writer.close();
    }

    private <T extends Comparable<T>> List<T> sorted(Iterable<T> classes) {
        ArrayList<Comparable> out = new ArrayList<Comparable>();
        for (Comparable t : classes) {
            out.add(t);
        }
        Collections.sort(out);
        return out;
    }
}

