/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cuchaz.enigma.mapping.entry.Entry;
import java.util.ArrayList;
import java.util.List;

public class ClassEntry
implements Entry {
    private final String name;

    public ClassEntry(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"Class name cannot be null");
        if (className.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name must be in JVM format. ie, path/to/package/class$inner : " + className);
        }
        this.name = className;
        if (this.isInnerClass() && this.getInnermostClassName().indexOf(47) >= 0) {
            throw new IllegalArgumentException("Inner class must not have a package: " + className);
        }
    }

    public ClassEntry(ClassEntry other) {
        this.name = other.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.name;
    }

    @Override
    public ClassEntry getOwnerClassEntry() {
        return this;
    }

    @Override
    public ClassEntry updateOwnership(ClassEntry classEntry) {
        return classEntry;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ClassEntry && this.equals((ClassEntry)other);
    }

    public boolean equals(ClassEntry other) {
        return other != null && this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean isArray() {
        return this.name.lastIndexOf(91) >= 0;
    }

    public boolean isInnerClass() {
        return this.name.lastIndexOf(36) >= 0;
    }

    public List<String> getClassChainNames() {
        return Lists.newArrayList((Object[])this.name.split("\\$"));
    }

    public List<ClassEntry> getClassChain() {
        ArrayList entries = Lists.newArrayList();
        StringBuilder buf = new StringBuilder();
        for (String name : this.getClassChainNames()) {
            if (buf.length() > 0) {
                buf.append("$");
            }
            buf.append(name);
            entries.add(new ClassEntry(buf.toString()));
        }
        return entries;
    }

    public String getOutermostClassName() {
        if (this.isInnerClass()) {
            return this.name.substring(0, this.name.indexOf(36));
        }
        return this.name;
    }

    public ClassEntry getOutermostClassEntry() {
        return new ClassEntry(this.getOutermostClassName());
    }

    public String getOuterClassName() {
        if (!this.isInnerClass()) {
            throw new Error("This is not an inner class!");
        }
        return this.name.substring(0, this.name.lastIndexOf(36));
    }

    public ClassEntry getOuterClassEntry() {
        return new ClassEntry(this.getOuterClassName());
    }

    public String getInnermostClassName() {
        if (!this.isInnerClass()) {
            throw new Error("This is not an inner class!");
        }
        return this.name.substring(this.name.lastIndexOf(36) + 1);
    }

    public boolean isInDefaultPackage() {
        return this.name.indexOf(47) < 0;
    }

    public String getPackageName() {
        return ClassEntry.getPackageName(this.name);
    }

    public String getSimpleName() {
        int pos = this.name.lastIndexOf(47);
        if (pos > 0) {
            return this.name.substring(pos + 1);
        }
        return this.name;
    }

    public static String getPackageName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return null;
    }

    public ClassEntry buildClassEntry(List<ClassEntry> classChain) {
        assert (classChain.contains(this));
        StringBuilder buf = new StringBuilder();
        for (ClassEntry chainEntry : classChain) {
            if (buf.length() == 0) {
                buf.append(chainEntry.getName());
            } else {
                buf.append("$");
                buf.append(chainEntry.isInnerClass() ? chainEntry.getInnermostClassName() : chainEntry.getSimpleName());
            }
            if (chainEntry != this) continue;
            break;
        }
        return new ClassEntry(buf.toString());
    }
}

