/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.MethodDescriptor;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.DefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;

public class MethodDefEntry
extends MethodEntry
implements DefEntry {
    private final AccessFlags access;
    private final Signature signature;

    public MethodDefEntry(ClassEntry classEntry, String name, MethodDescriptor descriptor, Signature signature, AccessFlags access) {
        super(classEntry, name, descriptor);
        Preconditions.checkNotNull((Object)access, (Object)"Method access cannot be null");
        Preconditions.checkNotNull((Object)signature, (Object)"Method signature cannot be null");
        this.access = access;
        this.signature = signature;
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public MethodDefEntry updateOwnership(ClassEntry classEntry) {
        return new MethodDefEntry(new ClassEntry(classEntry.getName()), this.name, this.descriptor, this.signature, this.access);
    }

    public int getArgumentIndex(ClassDefEntry ownerEntry, int localVariableIndex) {
        int argumentIndex = localVariableIndex;
        if (ownerEntry.getAccess().isEnum() && this.getName().startsWith("<")) {
            argumentIndex -= 2;
        }
        if (!this.getAccess().isStatic()) {
            --argumentIndex;
        }
        return argumentIndex;
    }
}

