/*
 * Decompiled with CFR 0.152.
 */
package oml.ast.transformers;

import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodBinder;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.semantics.ResolveResult;
import java.util.ArrayList;
import java.util.List;

public class VarargsFixer
implements IAstTransform {
    private final DecompilerContext _context;

    public VarargsFixer(DecompilerContext context) {
        this._context = (DecompilerContext)VerifyArgument.notNull((Object)context, (String)"context");
    }

    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor((IAstVisitor)new Visitor(this._context), null);
    }

    class Visitor
    extends ContextTrackingVisitor<Void> {
        private final JavaResolver _resolver;

        protected Visitor(DecompilerContext context) {
            super(context);
            this._resolver = new JavaResolver(context);
        }

        public Void visitInvocationExpression(InvocationExpression node, Void data) {
            AstNodeCollection arguments;
            Expression lastParam;
            super.visitInvocationExpression(node, (Object)data);
            MemberReference definition = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
            if (definition instanceof MethodDefinition && ((MethodDefinition)definition).isVarArgs() && !(lastParam = (Expression)(arguments = node.getArguments()).lastOrNullObject()).isNull() && lastParam instanceof ArrayCreationExpression) {
                ArrayCreationExpression varargArray = (ArrayCreationExpression)lastParam;
                if (varargArray.getInitializer().isNull() || varargArray.getInitializer().getElements().isEmpty()) {
                    lastParam.remove();
                } else {
                    for (Expression e : varargArray.getInitializer().getElements()) {
                        arguments.insertBefore((AstNode)varargArray, (AstNode)e.clone());
                    }
                    varargArray.remove();
                }
            }
            return null;
        }

        public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
            MethodBinder.BindResult c2;
            boolean hasElements;
            List candidates;
            Expression lastArgument;
            super.visitObjectCreationExpression(node, (Object)data);
            AstNodeCollection arguments = node.getArguments();
            Expression arrayArg = lastArgument = (Expression)arguments.lastOrNullObject();
            if (arrayArg instanceof CastExpression) {
                arrayArg = ((CastExpression)arrayArg).getExpression();
            }
            if (arrayArg == null || arrayArg.isNull() || !(arrayArg instanceof ArrayCreationExpression) || !(node.getTarget() instanceof MemberReferenceExpression)) {
                return null;
            }
            ArrayCreationExpression newArray = (ArrayCreationExpression)arrayArg;
            MemberReferenceExpression target = (MemberReferenceExpression)node.getTarget();
            if (!newArray.getAdditionalArraySpecifiers().hasSingleElement()) {
                return null;
            }
            MethodReference method = (MethodReference)node.getUserData(Keys.MEMBER_REFERENCE);
            if (method == null) {
                return null;
            }
            MethodDefinition resolved = method.resolve();
            if (resolved == null || !resolved.isVarArgs()) {
                return null;
            }
            Expression invocationTarget = target.getTarget();
            if (invocationTarget == null || invocationTarget.isNull()) {
                candidates = MetadataHelper.findMethods((TypeReference)this.context.getCurrentType(), (Predicate)MetadataFilters.matchName((String)resolved.getName()));
            } else {
                ResolveResult targetResult = this._resolver.apply((AstNode)invocationTarget);
                if (targetResult == null || targetResult.getType() == null) {
                    return null;
                }
                candidates = MetadataHelper.findMethods((TypeReference)targetResult.getType(), (Predicate)MetadataFilters.matchName((String)resolved.getName()));
            }
            ArrayList<TypeReference> argTypes = new ArrayList<TypeReference>();
            for (Expression argument : arguments) {
                ResolveResult argResult = this._resolver.apply((AstNode)argument);
                if (argResult == null || argResult.getType() == null) {
                    return null;
                }
                argTypes.add(argResult.getType());
            }
            MethodBinder.BindResult c1 = MethodBinder.selectMethod((List)candidates, argTypes);
            if (c1.isFailure() || c1.isAmbiguous()) {
                return null;
            }
            argTypes.remove(argTypes.size() - 1);
            ArrayInitializerExpression initializer = newArray.getInitializer();
            boolean bl = hasElements = !initializer.isNull() && !initializer.getElements().isEmpty();
            if (hasElements) {
                for (Expression argument : initializer.getElements()) {
                    ResolveResult argResult = this._resolver.apply((AstNode)argument);
                    if (argResult == null || argResult.getType() == null) {
                        return null;
                    }
                    argTypes.add(argResult.getType());
                }
            }
            if ((c2 = MethodBinder.selectMethod((List)candidates, argTypes)).isFailure() || c2.isAmbiguous() || !StringUtilities.equals((String)c2.getMethod().getErasedSignature(), (String)c1.getMethod().getErasedSignature())) {
                return null;
            }
            lastArgument.remove();
            if (!hasElements) {
                lastArgument.remove();
                return null;
            }
            for (Expression newArg : initializer.getElements()) {
                newArg.remove();
                arguments.add((AstNode)newArg);
            }
            return null;
        }
    }
}

