/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ClassReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<ClassEntry, MethodDefEntry> {
    private Translator deobfuscatingTranslator;
    private ClassEntry entry;
    private EntryReference<ClassEntry, MethodDefEntry> reference;
    private AccessFlags access;

    public ClassReferenceTreeNode(Translator deobfuscatingTranslator, ClassEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    public ClassReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<ClassEntry, MethodDefEntry> reference, AccessFlags access) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (ClassEntry)reference.entry;
        this.reference = reference;
        this.access = access;
    }

    @Override
    public ClassEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<ClassEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s (%s)", this.deobfuscatingTranslator.getTranslatedMethodDef((MethodDefEntry)this.reference.context), this.access);
        }
        return this.deobfuscatingTranslator.getTranslatedClass(this.entry).getName();
    }

    public void load(JarIndex index, boolean recurse) {
        for (EntryReference<ClassEntry, MethodDefEntry> reference : index.getMethodsReferencing(this.entry)) {
            this.add(new ClassReferenceTreeNode(this.deobfuscatingTranslator, reference, index.getAccessFlags(this.entry)));
        }
        if (recurse && this.children != null) {
            for (EntryReference<ClassEntry, MethodDefEntry> child : this.children) {
                if (!(child instanceof ClassReferenceTreeNode)) continue;
                ClassReferenceTreeNode node = (ClassReferenceTreeNode)((Object)child);
                HashSet ancestors = Sets.newHashSet();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof ClassReferenceTreeNode)) continue;
                    ancestors.add(((ClassReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true);
            }
        }
    }
}

