/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.entry.ClassDefEntry;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.DefEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.mapping.entry.FieldDefEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.mapping.entry.MethodEntry;
import cuchaz.enigma.mapping.entry.ReferencedEntryPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranslationIndex {
    private final ReferencedEntryPool entryPool;
    private Map<ClassEntry, ClassEntry> superclasses;
    private Map<Entry, DefEntry> defEntries = new HashMap<Entry, DefEntry>();
    private Multimap<ClassEntry, FieldDefEntry> fieldEntries;
    private Multimap<ClassEntry, MethodDefEntry> methodEntries;
    private Multimap<ClassEntry, ClassEntry> interfaces;

    public TranslationIndex(ReferencedEntryPool entryPool) {
        this.entryPool = entryPool;
        this.superclasses = Maps.newHashMap();
        this.fieldEntries = HashMultimap.create();
        this.methodEntries = HashMultimap.create();
        this.interfaces = HashMultimap.create();
        for (DefEntry entry : this.fieldEntries.values()) {
            this.defEntries.put(entry, entry);
        }
        for (DefEntry entry : this.methodEntries.values()) {
            this.defEntries.put(entry, entry);
        }
    }

    public TranslationIndex(TranslationIndex other, Translator translator) {
        this.entryPool = other.entryPool;
        this.superclasses = Maps.newHashMap();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.superclasses.entrySet()) {
            this.superclasses.put(translator.getTranslatedClass(mapEntry.getKey()), translator.getTranslatedClass(mapEntry.getValue()));
        }
        this.interfaces = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.interfaces.entries()) {
            this.interfaces.put((Object)translator.getTranslatedClass(mapEntry.getKey()), (Object)translator.getTranslatedClass(mapEntry.getValue()));
        }
        this.fieldEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.fieldEntries.entries()) {
            this.fieldEntries.put((Object)translator.getTranslatedClass(mapEntry.getKey()), (Object)translator.getTranslatedFieldDef((FieldDefEntry)((Object)mapEntry.getValue())));
        }
        this.methodEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.methodEntries.entries()) {
            this.methodEntries.put((Object)translator.getTranslatedClass(mapEntry.getKey()), (Object)translator.getTranslatedMethodDef((MethodDefEntry)((Object)mapEntry.getValue())));
        }
        for (DefEntry entry : this.fieldEntries.values()) {
            this.defEntries.put(entry, entry);
        }
        for (DefEntry entry : this.methodEntries.values()) {
            this.defEntries.put(entry, entry);
        }
    }

    protected ClassDefEntry indexClass(int access, String name, String signature, String superName, String[] interfaces) {
        ClassDefEntry classEntry = new ClassDefEntry(name, Signature.createSignature(signature), new AccessFlags(access));
        if (this.isJre(classEntry)) {
            return null;
        }
        ClassEntry superclassEntry = this.entryPool.getClass(superName);
        if (superclassEntry != null) {
            this.superclasses.put(classEntry, superclassEntry);
        }
        for (String interfaceClassName : interfaces) {
            ClassEntry interfaceClassEntry = this.entryPool.getClass(interfaceClassName);
            if (this.isJre(interfaceClassEntry)) continue;
            this.interfaces.put((Object)classEntry, (Object)interfaceClassEntry);
        }
        return classEntry;
    }

    protected void indexField(FieldDefEntry fieldEntry) {
        this.fieldEntries.put((Object)fieldEntry.getOwnerClassEntry(), (Object)fieldEntry);
        this.defEntries.put(fieldEntry, fieldEntry);
    }

    protected void indexMethod(MethodDefEntry methodEntry) {
        this.methodEntries.put((Object)methodEntry.getOwnerClassEntry(), (Object)methodEntry);
        this.defEntries.put(methodEntry, methodEntry);
    }

    public void renameClasses(Map<String, String> renames) {
        EntryRenamer.renameClassesInMap(renames, this.superclasses);
        EntryRenamer.renameClassesInMultimap(renames, this.fieldEntries);
        EntryRenamer.renameClassesInMultimap(renames, this.methodEntries);
        this.defEntries.clear();
        for (DefEntry entry : this.fieldEntries.values()) {
            this.defEntries.put(entry, entry);
        }
        for (DefEntry entry : this.methodEntries.values()) {
            this.defEntries.put(entry, entry);
        }
    }

    public ClassEntry getSuperclass(ClassEntry classEntry) {
        return this.superclasses.get(classEntry);
    }

    public List<ClassEntry> getAncestry(ClassEntry classEntry) {
        ArrayList ancestors = Lists.newArrayList();
        while (classEntry != null) {
            if ((classEntry = this.getSuperclass(classEntry)) == null) continue;
            ancestors.add(classEntry);
        }
        return ancestors;
    }

    public List<ClassEntry> getImplementers(ClassEntry classEntry) {
        ArrayList implementers = Lists.newArrayList();
        for (ClassEntry itf : this.interfaces.keySet()) {
            if (!this.interfaces.containsEntry((Object)itf, (Object)classEntry)) continue;
            implementers.add(itf);
        }
        return implementers;
    }

    public List<ClassEntry> getSubclass(ClassEntry classEntry) {
        ArrayList subclasses = Lists.newArrayList();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.superclasses.entrySet()) {
            ClassEntry subclass = entry.getKey();
            ClassEntry superclass = entry.getValue();
            if (!classEntry.equals(superclass)) continue;
            subclasses.add(subclass);
        }
        return subclasses;
    }

    public void getSubclassesRecursively(Set<ClassEntry> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry);
            this.getSubclassesRecursively(out, subclassEntry);
        }
    }

    public void getSubclassNamesRecursively(Set<String> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry.getName());
            this.getSubclassNamesRecursively(out, subclassEntry);
        }
    }

    public Collection<Map.Entry<ClassEntry, ClassEntry>> getClassInterfaces() {
        return this.interfaces.entries();
    }

    public Collection<ClassEntry> getInterfaces(ClassEntry classEntry) {
        return this.interfaces.get((Object)classEntry);
    }

    public boolean isInterface(ClassEntry classEntry) {
        return this.interfaces.containsValue((Object)classEntry);
    }

    public boolean entryExists(Entry entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof FieldEntry) {
            return this.fieldExists((FieldEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return this.methodExists((MethodEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return this.methodExists(((LocalVariableEntry)entry).getOwnerEntry());
        }
        throw new IllegalArgumentException("Cannot check existence for " + entry.getClass());
    }

    public boolean fieldExists(FieldEntry fieldEntry) {
        return this.fieldEntries.containsEntry((Object)fieldEntry.getOwnerClassEntry(), (Object)fieldEntry);
    }

    public boolean methodExists(MethodEntry methodEntry) {
        return this.methodEntries.containsEntry((Object)methodEntry.getOwnerClassEntry(), (Object)methodEntry);
    }

    public ClassEntry resolveEntryOwner(Entry entry) {
        if (entry instanceof ClassEntry) {
            return (ClassEntry)entry;
        }
        if (this.entryExists(entry)) {
            return entry.getOwnerClassEntry();
        }
        DefEntry def = this.defEntries.get(entry);
        if (def != null && def.getAccess().isPrivate()) {
            return null;
        }
        LinkedList<ClassEntry> classEntries = new LinkedList<ClassEntry>();
        classEntries.add(entry.getOwnerClassEntry());
        while (!classEntries.isEmpty()) {
            ClassEntry c = (ClassEntry)classEntries.remove();
            Entry cEntry = entry.updateOwnership(c);
            if (this.entryExists(cEntry) && ((def = this.defEntries.get(cEntry)) == null || !def.getAccess().isPrivate())) {
                return cEntry.getOwnerClassEntry();
            }
            ClassEntry superC = this.getSuperclass(c);
            if (superC != null) {
                classEntries.add(superC);
            }
            if (!(entry instanceof MethodEntry)) continue;
            classEntries.addAll(this.getInterfaces(c));
        }
        return null;
    }

    private boolean isJre(ClassEntry classEntry) {
        String packageName = classEntry.getPackageName();
        return packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax"));
    }
}

