/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.bytecode.AccessFlags;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.DefEntry;
import cuchaz.enigma.mapping.entry.FieldEntry;

public class FieldDefEntry
extends FieldEntry
implements DefEntry {
    private final AccessFlags access;
    private final Signature signature;

    public FieldDefEntry(ClassEntry ownerEntry, String name, TypeDescriptor desc, Signature signature, AccessFlags access) {
        super(ownerEntry, name, desc);
        Preconditions.checkNotNull((Object)access, (Object)"Field access cannot be null");
        Preconditions.checkNotNull((Object)signature, (Object)"Field signature cannot be null");
        this.access = access;
        this.signature = signature;
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public FieldDefEntry updateOwnership(ClassEntry owner) {
        return new FieldDefEntry(owner, this.name, this.desc, this.signature, this.access);
    }
}

