/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.Entry;
import cuchaz.enigma.utils.Utils;

public class FieldEntry
implements Entry {
    protected final ClassEntry ownerEntry;
    protected final String name;
    protected final TypeDescriptor desc;

    public FieldEntry(ClassEntry ownerEntry, String name, TypeDescriptor desc) {
        Preconditions.checkNotNull((Object)ownerEntry, (Object)"Owner cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Field name cannot be null");
        Preconditions.checkNotNull((Object)desc, (Object)"Field descriptor cannot be null");
        this.ownerEntry = ownerEntry;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public ClassEntry getOwnerClassEntry() {
        return this.ownerEntry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.ownerEntry.getName();
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public FieldEntry updateOwnership(ClassEntry owner) {
        return new FieldEntry(owner, this.name, this.desc);
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.ownerEntry, this.name, this.desc);
    }

    public boolean equals(Object other) {
        return other instanceof FieldEntry && this.equals((FieldEntry)other);
    }

    public boolean equals(FieldEntry other) {
        return this.ownerEntry.equals(other.ownerEntry) && this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    public String toString() {
        return this.ownerEntry.getName() + "." + this.name + ":" + this.desc;
    }
}

