/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.mapping.TypeDescriptor;
import cuchaz.enigma.mapping.entry.ClassEntry;
import cuchaz.enigma.mapping.entry.LocalVariableEntry;
import cuchaz.enigma.mapping.entry.MethodDefEntry;
import cuchaz.enigma.utils.Utils;

public class LocalVariableDefEntry
extends LocalVariableEntry {
    protected final MethodDefEntry ownerEntry;
    protected final TypeDescriptor desc;

    public LocalVariableDefEntry(MethodDefEntry ownerEntry, int index, String name, TypeDescriptor desc) {
        this(ownerEntry, index, name, true, desc);
    }

    public LocalVariableDefEntry(MethodDefEntry ownerEntry, int index, String name, boolean parameter, TypeDescriptor desc) {
        super(ownerEntry, index, name, parameter);
        Preconditions.checkNotNull((Object)desc, (Object)"Variable desc cannot be null");
        this.ownerEntry = ownerEntry;
        this.desc = desc;
    }

    @Override
    public MethodDefEntry getOwnerEntry() {
        return this.ownerEntry;
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public LocalVariableDefEntry updateOwnership(ClassEntry classEntry) {
        return new LocalVariableDefEntry(this.ownerEntry.updateOwnership(classEntry), this.index, this.name, this.parameter, this.desc);
    }

    @Override
    public int hashCode() {
        return Utils.combineHashesOrdered(this.ownerEntry, this.desc.hashCode(), this.name.hashCode(), Integer.hashCode(this.index));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LocalVariableDefEntry && this.equals((LocalVariableDefEntry)other);
    }

    public boolean equals(LocalVariableDefEntry other) {
        return this.ownerEntry.equals(other.ownerEntry) && this.desc.equals(other.desc) && this.name.equals(other.name) && this.index == other.index;
    }

    @Override
    public String toString() {
        return this.ownerEntry + "(" + this.index + ":" + this.name + ":" + this.desc + ")";
    }
}

